package wicket.quickstart.service;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import wicket.quickstart.domain.WikiPage;

public class MemoryStore
{
	private ConcurrentMap<String,WikiPage> nameToPage=new ConcurrentHashMap<String,WikiPage>();
	
	public void addPage(WikiPage page) {
		if (nameToPage.containsKey(page.getName())) {
			throw new RuntimeException("page with name already exists");
		}
		nameToPage.put(page.getName(), page);
	}
	
	public WikiPage getPage(String name) {
		if (!nameToPage.containsKey(name)) {
			throw new IllegalArgumentException("page [["+name+"]] not found");
		}
		return nameToPage.get(name);
	}
	
	public boolean pageExists(String pageName) {
		return nameToPage.containsKey(pageName);
	}

}
