package wicket.quickstart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import wicket.protocol.http.WebApplication;
import wicket.quickstart.domain.WikiPage;
import wicket.quickstart.service.MemoryStore;
import wicket.request.target.coding.IndexedParamUrlCodingStrategy;

/**
 * Runs the QuickStartApplication when invoked from command line.
 */
public class QuickStartApplication extends WebApplication
{
	/** Logging */
	private static final Log log = LogFactory.getLog(QuickStartApplication.class);

	private MemoryStore store = new MemoryStore();

	/**
	 * Constructor
	 */
	public QuickStartApplication()
	{
	}

	/**
	 * @see wicket.Application#getHomePage()
	 */
	public Class getHomePage()
	{
		return Index.class;
	}

	@Override
	protected void init()
	{
		WikiPage home = new WikiPage();
		home.setName("home");
		home.setContent("this is the __home page__. here is a link to the [second] page.");
		store.addPage(home);

		WikiPage second = new WikiPage();
		second.setName("second");
		second.setContent("this is the second page");
		store.addPage(second);

		mount("/page", new IndexedParamUrlCodingStrategy("/page", HostPage.class));
	}

	public MemoryStore getStore()
	{
		return store;
	}

}