package wicket.quickstart;

import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.WikiRenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.engine.context.BaseRenderContext;

import wicket.Application;
import wicket.Component;
import wicket.PageMap;
import wicket.PageParameters;
import wicket.RequestCycle;
import wicket.model.AbstractReadOnlyModel;
import wicket.model.IModel;
import wicket.quickstart.domain.WikiPage;

public class PageContentModel extends AbstractReadOnlyModel
{
	private IModel pageModel;
	
	public PageContentModel(IModel pageModel) {
		this.pageModel=pageModel;
	}
	
	
	
	private static class MyRenderEngine extends BaseRenderEngine implements WikiRenderEngine {

		public boolean exists(String name)
		{
			return ((QuickStartApplication)Application.get()).getStore().pageExists(name);
		}

		public boolean showCreate()
		{
			return false;
		}

		public void appendLink(StringBuffer buffer, String name, String view, String anchor)
		{
			throw new UnsupportedOperationException();
			
		}

		public void appendLink(StringBuffer buffer, String name, String view)
		{
			PageParameters params=new PageParameters();
			params.put("0", name);
			String url=RequestCycle.get().urlFor(PageMap.forName(PageMap.DEFAULT_NAME), HostPage.class, params);
			
			buffer.append("<a href=\"").append(url).append("\">").append(view).append("</a>");

			
		}

		public void appendCreateLink(StringBuffer buffer, String name, String view)
		{
			throw new UnsupportedOperationException();
			
		}
		
	}
	
	@Override
	public Object getObject(Component component)
	{
		WikiPage page=(WikiPage) pageModel.getObject(component);
		
		RenderEngine engine=new MyRenderEngine();
		RenderContext context=new BaseRenderContext();
		context.setRenderEngine(engine);
		String result=engine.render(page.getContent(), context);
		
		return result;
		
		
		
		
/*		StringBuilder builder=new StringBuilder(page.getContent());
		
		Pattern link=Pattern.compile("\\[([^\\]]+)\\]");
		Matcher matcher=link.matcher(builder);
		while (matcher.find()) {
			MatchResult res=matcher.toMatchResult();
			int start=res.start();
			int end=res.end();
			
			String[] temp=builder.substring(start+1, end-1).split("[|]");
			
			
			
			PageParameters params=new PageParameters();
			params.put("0", temp[1]);
			
			String url=RequestCycle.get().urlFor(PageMap.forName(PageMap.DEFAULT_NAME), HostPage.class, params);
			String rep="<a href=\""+url+"\">"+temp[0]+"</a>";
			
			builder.replace(start, end, rep);
			
			matcher.reset();
			
		}
		
		return builder.toString();
		*/
	}

}
