package wicket.quickstart;

import wicket.PageParameters;
import wicket.RestartResponseException;
import wicket.markup.html.WebPage;

/**
 * Basic bookmarkable index page.
 * 
 * NOTE: You can get session properties from QuickStartSession via getQuickStartSession()
 */
public class Index extends WebPage
{

	/**
	 * Constructor that is invoked when page is invoked without a session.
	 * 
	 * @param parameters
	 *            Page parameters
	 */
	public Index(final PageParameters parameters) 
    {
		// we cant mount a page onto / so we always go to hostpage
		PageParameters params=new PageParameters();
		params.put("0", "home");
		throw new RestartResponseException(HostPage.class, params);
    }
	
}
