package wicket.quickstart;

import java.util.ArrayList;
import java.util.List;

import wicket.Application;
import wicket.PageParameters;
import wicket.extensions.markup.html.tabs.AbstractTab;
import wicket.extensions.markup.html.tabs.ITab;
import wicket.extensions.markup.html.tabs.TabbedPanel;
import wicket.markup.html.WebPage;
import wicket.markup.html.basic.Label;
import wicket.markup.html.link.PageLink;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;
import wicket.model.LoadableDetachableModel;
import wicket.model.Model;
import wicket.model.PropertyModel;
import wicket.quickstart.domain.WikiPage;

public class HostPage extends WebPage
{
	public HostPage(PageParameters params)
	{
		if (params == null || params.isEmpty())
		{
			init("home");
		}
		else
		{
			init(params.getString("0"));
		}
	}

	public HostPage(String pageName)
	{
		init(pageName);
	}

	private void init(final String pageName)
	{
		add(new PageLink("home-page-link", Index.class));
		add(new PageLink("add-page-link", AddPage.class));

		final IModel pageModel = new LoadableDetachableModel()
		{

			@Override
			protected Object load()
			{
				return ((QuickStartApplication) Application.get()).getStore().getPage(
						pageName);
			}

		};

		add(new Label("page-name-label", new PropertyModel(pageModel, "name")));

		List<ITab> tabs = new ArrayList<ITab>();
		tabs.add(new AbstractTab(new Model("view"))
		{

			@Override
			public Panel getPanel(String panelId)
			{
				return new DisplayPanel(panelId, pageModel);
			}

		});

		tabs.add(new AbstractTab(new Model("edit"))
		{

			@Override
			public Panel getPanel(String panelId)
			{
				WikiPage page = (WikiPage) pageModel.getObject(null);

				return new EditPanel(panelId, page)
				{

					@Override
					protected void onCancel()
					{
						goback();
					}

					@Override
					protected void onSave(EditPageBean bean)
					{
						WikiPage page = (WikiPage) pageModel.getObject(null);
						page.setContent(bean.getContent());
						goback();
					}

					private void goback()
					{
						TabbedPanel tp = (TabbedPanel) findParent(TabbedPanel.class);
						tp.setSelectedTab(0);
					}

				};
			}

		});

		add(new TabbedPanel("tabs", tabs));

	}
}
