package wicket.quickstart;

import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.form.Button;
import wicket.markup.html.form.Form;
import wicket.markup.html.form.TextArea;
import wicket.markup.html.form.TextField;
import wicket.markup.html.panel.Panel;
import wicket.model.CompoundPropertyModel;
import wicket.quickstart.domain.WikiPage;

public abstract class EditPanel extends Panel
{
	
	public EditPanel(String id) {
		this(id, null);
	}

	public EditPanel(String id, WikiPage page)
	{
		super(id);
		final boolean editName=(page==null);
		
		EditPageBean bean;
		
		if (page!=null) {
			bean=new EditPageBean(page);
		} else {
			bean=new EditPageBean();
		}

		Form form = new Form("form", new CompoundPropertyModel(bean));
		add(form);
		form.add(new TextArea("content"));
		
		WebMarkupContainer nameContainer=new WebMarkupContainer("name-container") {
			@Override
			public boolean isVisible()
			{
				return editName;
			}
		};
		form.add(nameContainer);
		
		nameContainer.add(new TextField("name"));
		
		form.add(new Button("save")
		{
			@Override
			protected void onSubmit()
			{
				onSave((EditPageBean)getForm().getModelObject());
			}
		});

		form.add(new Button("cancel")
		{
			@Override
			protected void onSubmit()
			{
				onCancel();
			}
		});
	}

	protected abstract void onCancel();

	protected abstract void onSave(EditPageBean bean);

}
