package wicket.quickstart;

import wicket.Application;
import wicket.markup.html.WebPage;
import wicket.quickstart.domain.WikiPage;

public class AddPage extends WebPage
{
	public AddPage() {
		add(new EditPanel("edit-panel") {

			@Override
			protected void onCancel()
			{
				setResponsePage(Index.class);
			}

			@Override
			protected void onSave(EditPageBean bean)
			{
				WikiPage page=new WikiPage();
				page.setName(bean.getName());
				page.setContent(bean.getContent());
				
				((QuickStartApplication)Application.get()).getStore().addPage(page);
				
				setResponsePage(new HostPage(page.getName()));
			}
			
		});
	}
}
