-- MySQL dump 10.11
--
-- Host: localhost    Database: policyd
-- ------------------------------------------------------
-- Server version	5.0.95

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `policies`
--

DROP TABLE IF EXISTS `policies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `policies` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `Name` varchar(255) collate latin1_bin NOT NULL,
  `Priority` smallint(6) NOT NULL,
  `Description` text collate latin1_bin,
  `Disabled` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policies`
--

LOCK TABLES `policies` WRITE;
/*!40000 ALTER TABLE `policies` DISABLE KEYS */;
INSERT INTO `policies` VALUES (1,'Default',0,'Default System Policy',0),(3,'Outbound Policy',10,'Outbound Policy',0);
/*!40000 ALTER TABLE `policies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_group_members`
--

DROP TABLE IF EXISTS `policy_group_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `policy_group_members` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `PolicyGroupID` bigint(20) unsigned default NULL,
  `Member` varchar(255) collate latin1_bin NOT NULL,
  `Disabled` smallint(6) NOT NULL default '0',
  `Comment` varchar(1024) collate latin1_bin default NULL,
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`),
  KEY `polid_member_disabled_idx` (`PolicyGroupID`,`Member`,`Disabled`),
  CONSTRAINT `policy_group_members_ibfk_1` FOREIGN KEY (`PolicyGroupID`) REFERENCES `policy_groups` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_group_members`
--

LOCK TABLES `policy_group_members` WRITE;
/*!40000 ALTER TABLE `policy_group_members` DISABLE KEYS */;
INSERT INTO `policy_group_members` VALUES (2,2,'@example.com',0,''),(3,3,'10.0.0.0/8',0,''),(4,4,'208.91.198.54',0,'md-9 main ip');
/*!40000 ALTER TABLE `policy_group_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_groups`
--

DROP TABLE IF EXISTS `policy_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `policy_groups` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `Name` varchar(255) collate latin1_bin NOT NULL,
  `Disabled` smallint(6) NOT NULL default '0',
  `Comment` varchar(1024) collate latin1_bin default NULL,
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_groups`
--

LOCK TABLES `policy_groups` WRITE;
/*!40000 ALTER TABLE `policy_groups` DISABLE KEYS */;
INSERT INTO `policy_groups` VALUES (2,'internal_domains',1,''),(3,'internal_ips',1,''),(4,'track_ip',0,'md-9');
/*!40000 ALTER TABLE `policy_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_members`
--

DROP TABLE IF EXISTS `policy_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `policy_members` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `PolicyID` bigint(20) unsigned default NULL,
  `Source` text collate latin1_bin,
  `Destination` text collate latin1_bin,
  `Comment` varchar(1024) collate latin1_bin default NULL,
  `Disabled` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`),
  KEY `PolicyID` (`PolicyID`),
  CONSTRAINT `policy_members_ibfk_1` FOREIGN KEY (`PolicyID`) REFERENCES `policies` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_members`
--

LOCK TABLES `policy_members` WRITE;
/*!40000 ALTER TABLE `policy_members` DISABLE KEYS */;
INSERT INTO `policy_members` VALUES (3,3,'!%internal_ips,!%internal_domains','any','',1),(4,3,'%track_ip','any','',0);
/*!40000 ALTER TABLE `policy_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotas` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `PolicyID` bigint(20) unsigned default NULL,
  `Name` varchar(255) collate latin1_bin NOT NULL,
  `Track` varchar(255) collate latin1_bin NOT NULL,
  `Period` bigint(20) unsigned default NULL,
  `Verdict` varchar(255) collate latin1_bin default NULL,
  `Data` text collate latin1_bin,
  `Comment` varchar(1024) collate latin1_bin default NULL,
  `Disabled` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`),
  KEY `PolicyID` (`PolicyID`),
  CONSTRAINT `quotas_ibfk_1` FOREIGN KEY (`PolicyID`) REFERENCES `policies` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` VALUES (1,3,'Global limit per sender','Sender:user@domain',3600,'REJECT','550 5.4.5 Email Sending Quota Exceeded','Global limit per sender',0),(2,3,'Global limit per domain','Sender:@domain',3600,'REJECT','550 5.4.5 Domain Sending Quota Exceeded','Global limit per domain',0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas_limits`
--

DROP TABLE IF EXISTS `quotas_limits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotas_limits` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `QuotasID` bigint(20) unsigned default NULL,
  `Type` varchar(255) collate latin1_bin default NULL,
  `CounterLimit` bigint(20) unsigned default NULL,
  `Comment` varchar(1024) collate latin1_bin default NULL,
  `Disabled` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`),
  KEY `QuotasID` (`QuotasID`),
  CONSTRAINT `quotas_limits_ibfk_1` FOREIGN KEY (`QuotasID`) REFERENCES `quotas` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas_limits`
--

LOCK TABLES `quotas_limits` WRITE;
/*!40000 ALTER TABLE `quotas_limits` DISABLE KEYS */;
INSERT INTO `quotas_limits` VALUES (1,1,'MessageCount',100,'Email limit per sender per hour',0),(2,2,'MessageCount',300,'Email limit per domain per hour',0);
/*!40000 ALTER TABLE `quotas_limits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas_tracking`
--

DROP TABLE IF EXISTS `quotas_tracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotas_tracking` (
  `QuotasLimitsID` bigint(20) unsigned default NULL,
  `TrackKey` varchar(512) collate latin1_bin default NULL,
  `LastUpdate` bigint(20) unsigned default NULL,
  `Counter` decimal(10,4) default NULL,
  UNIQUE KEY `QuotasLimitsID` (`QuotasLimitsID`,`TrackKey`),
  KEY `quotas_tracking_idx1` (`LastUpdate`),
  CONSTRAINT `quotas_tracking_ibfk_1` FOREIGN KEY (`QuotasLimitsID`) REFERENCES `quotas_limits` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas_tracking`
--

LOCK TABLES `quotas_tracking` WRITE;
/*!40000 ALTER TABLE `quotas_tracking` DISABLE KEYS */;
INSERT INTO `quotas_tracking` VALUES (1,'Sender:gotomh9j@md-9.webhostbox.net',1345797143,'46.0880'),(2,'Sender:@md-9.webhostbox.net',1345797143,'61.0548'),(1,'Sender:labourlawsinstitute@gmail.com',1345717517,'1.0000'),(2,'Sender:@gmail.com',1345794843,'2.7922'),(1,'Sender:epromael@md-9.webhostbox.net',1345794915,'1.3450'),(1,'Sender:@',1345796830,'4.9676'),(2,'Sender:@',1345796830,'4.9676'),(1,'Sender:idcard@aradhanas.in',1345794104,'2.1674'),(2,'Sender:@aradhanas.in',1345794104,'2.1674'),(1,'Sender:bounces+128803-c03b-juaristi=vsnl.net@sendgrid.info',1345717720,'1.0000'),(2,'Sender:@sendgrid.info',1345783372,'1.0000'),(1,'Sender:bharat.iyer@apsinternationalmovers.com',1345730293,'1.0000'),(2,'Sender:@apsinternationalmovers.com',1345730553,'5.9900'),(1,'Sender:mohammed.alkhatim@nilebarges.com',1345717792,'2.9991'),(2,'Sender:@nilebarges.com',1345717792,'2.9991'),(1,'Sender:qmasim@gmail.com',1345717819,'1.0000'),(1,'Sender:root@md-9.webhostbox.net',1345796285,'2.5208'),(1,'Sender:virairfu@md-9.webhostbox.net',1345796854,'1.8700'),(1,'Sender:s-x5qqzcc5a_bqjag35fqmjoauz4dqmll05y-mhxh7lqb_baaab_-zsr@bounce.linkedin.com',1345718058,'1.0000'),(2,'Sender:@bounce.linkedin.com',1345763390,'1.0000'),(1,'Sender:kaskauth@md-9.webhostbox.net',1345791839,'1.0000'),(1,'Sender:dungvv@inet.vn',1345718143,'1.0000'),(2,'Sender:@inet.vn',1345718143,'1.0000'),(1,'Sender:info@oriententerprise.co.in',1345795527,'3.5300'),(2,'Sender:@oriententerprise.co.in',1345795527,'3.8914'),(1,'Sender:info@juaristi.co.in',1345795581,'2.6883'),(2,'Sender:@juaristi.co.in',1345795581,'2.6883'),(1,'Sender:rp@garimatrans.in',1345790391,'1.0000'),(2,'Sender:@garimatrans.in',1345790391,'1.0000'),(1,'Sender:supervisorantioquia@salesupsa.com',1345786779,'12.4431'),(2,'Sender:@salesupsa.com',1345794056,'1.0000'),(1,'Sender:amit@samalogistics.com',1345723435,'1.5769'),(2,'Sender:@samalogistics.com',1345723435,'1.5769'),(1,'Sender:vishal@parexindia.com',1345730500,'1.9997'),(2,'Sender:@parexindia.com',1345793181,'1.9997'),(1,'Sender:noreply@difusionelectronica.institutocervantes.es',1345722032,'1.0000'),(2,'Sender:@difusionelectronica.institutocervantes.es',1345722032,'1.0000'),(1,'Sender:nadia@kaskad-travel.ru',1345740870,'2.0880'),(2,'Sender:@kaskad-travel.ru',1345795555,'1.5194'),(1,'Sender:faisal@apsinternationalmovers.com',1345730553,'3.8242'),(1,'Sender:kunjan@masc.co.in',1345726407,'1.0000'),(2,'Sender:@masc.co.in',1345759600,'1.0000'),(1,'Sender:sales@faabind.com',1345788228,'1.0000'),(2,'Sender:@faabind.com',1345793414,'3.9986'),(1,'Sender:admin@sagesolutions.org.in',1345723131,'1.9997'),(2,'Sender:@sagesolutions.org.in',1345723131,'1.9997'),(1,'Sender:contact@trainertrainingcourse.com',1345796427,'100.9763'),(2,'Sender:@trainertrainingcourse.com',1345796427,'102.4208'),(1,'Sender:feroz@pdwdubai.com',1345723358,'1.0000'),(2,'Sender:@pdwdubai.com',1345723358,'1.0000'),(1,'Sender:epro-2026-1600-service=juaristi.co.in@mail.insideurbox.in',1345723381,'1.0000'),(2,'Sender:@mail.insideurbox.in',1345795827,'2.0118'),(1,'Sender:supervisorbogota1@salesupsa.com',1345782765,'1.7133'),(1,'Sender:bintabasim@yahoo.co.uk',1345723971,'1.0000'),(2,'Sender:@yahoo.co.uk',1345723971,'1.0000'),(1,'Sender:supervisorbogota6@salesupsa.com',1345777854,'2.8283'),(1,'Sender:ashaikh@internationalbuildersme.com',1345724158,'1.0000'),(2,'Sender:@internationalbuildersme.com',1345726859,'1.2497'),(1,'Sender:s-qwd_cbkiosgvy8vqvcoq7d5r0q6il8lq2po_ajjfa06m5ogqi__pat@bounce.linkedin.com',1345724706,'1.0000'),(1,'Sender:tony-_malala1@hotmail.com',1345724710,'1.0000'),(2,'Sender:@hotmail.com',1345786345,'1.9997'),(1,'Sender:dailyupdate@machinetools.com',1345724773,'1.0000'),(2,'Sender:@machinetools.com',1345724773,'1.0000'),(1,'Sender:tsvyas@mhe.elecon.com',1345725954,'1.7831'),(2,'Sender:@mhe.elecon.com',1345725954,'1.7831'),(1,'Sender:muthu@moralhand.com',1345796312,'10.4238'),(2,'Sender:@moralhand.com',1345796312,'10.4238'),(1,'Sender:neha@bhartiyaminternationalschool.com',1345725395,'1.0000'),(2,'Sender:@bhartiyaminternationalschool.com',1345774533,'1.0000'),(1,'Sender:cdhimole@gmail.com',1345725597,'1.0000'),(1,'Sender:cdhimole@yahoo.com',1345725660,'1.0000'),(2,'Sender:@yahoo.com',1345792039,'3.0049'),(1,'Sender:retahec@hotmail.com',1345725843,'1.0000'),(1,'Sender:mohit@intelmacindia.com',1345726557,'1.0000'),(2,'Sender:@intelmacindia.com',1345726557,'1.0000'),(1,'Sender:sales@aaravinfotech.com',1345795495,'0.9811'),(2,'Sender:@aaravinfotech.com',1345796342,'4.2723'),(1,'Sender:puloja_pjt@yahoo.com',1345726653,'1.0000'),(1,'Sender:store@parexindia.com',1345726752,'1.0000'),(1,'Sender:kmahendhiran@internationalbuildersme.com',1345726859,'1.0000'),(1,'Sender:mahendra@aaravinfotech.com',1345792217,'2.3631'),(1,'Sender:s-u6xpajz9jnticme-odq1zyixyjporzkdngxjxgk9hdpoui3k5f2ee8@bounce.linkedin.com',1345727031,'1.0000'),(1,'Sender:auxiliarnomina@salesupsa.com',1345758998,'1.0459'),(1,'Sender:azhar@apsinternationalmovers.com',1345729744,'1.2717'),(1,'Sender:dany_nike13@yahoo.com',1345727191,'1.0000'),(1,'Sender:enquiry@aradhanas.in',1345788359,'2.7989'),(1,'Sender:uk.total.gas+gmcfv7e15cf76f813182e@gmail.com',1345727793,'1.0000'),(1,'Sender:senanomina@salesupsa.com',1345758731,'2.8445'),(1,'Sender:akshay.asthana@masc.co.in',1345728029,'1.0000'),(1,'Sender:vgiraldo@salesupsa.com',1345764213,'8.8072'),(1,'Sender:storefabric@parexindia.com',1345784086,'1.0000'),(1,'Sender:coordinadoroccidente@salesupsa.com',1345757646,'5.0340'),(1,'Sender:liderpasto@salesupsa.com',1345773205,'4.1537'),(1,'Sender:sarita@aaravinfotech.com',1345796342,'2.0000'),(1,'Sender:supervisorbogota4@salesupsa.com',1345777897,'4.1041'),(1,'Sender:bounce_352@jrly.in',1345744223,'1.0000'),(2,'Sender:@jrly.in',1345744223,'1.0000'),(1,'Sender:training@imtmatrng.in',1345729150,'1.0000'),(2,'Sender:@imtmatrng.in',1345729150,'1.0000'),(1,'Sender:auxiliarbodega@salesupsa.com',1345729171,'1.0000'),(1,'Sender:liderbarranquilla@salesupsa.com',1345757402,'2.4360'),(1,'Sender:geekfvcz@md-9.webhostbox.net',1345729775,'1.0000'),(1,'Sender:imagilrt@md-9.webhostbox.net',1345729801,'1.0000'),(1,'Sender:coordinadorantioquia@salesupsa.com',1345738935,'2.1479'),(1,'Sender:instructorantioquiaps@salesupsa.com',1345747395,'1.9997'),(1,'Sender:sonicdyj@md-9.webhostbox.net',1345730309,'1.0000'),(1,'Sender:muhammadafiq_abdullah@yahoo.com',1345730443,'1.0000'),(1,'Sender:nastya@kaskad-travel.ru',1345795555,'1.5194'),(1,'Sender:coordinadorcosta@salesupsa.com',1345739419,'1.9581'),(1,'Sender:dinayen.heredia@am.sony.com',1345776244,'2.4224'),(2,'Sender:@am.sony.com',1345776244,'2.5111'),(1,'Sender:jangir.anil@aaravinfotech.com',1345730801,'1.0000'),(1,'Sender:coordinadorcentro1@salesupsa.com',1345780257,'1.9150'),(1,'Sender:supervisorbogota5@salesupsa.com',1345781340,'2.5040'),(1,'Sender:andres.zuluaga@am.sony.com',1345731035,'1.9997'),(1,'Sender:vision.kolhapurexpo@gmail.com',1345731149,'1.0000'),(1,'Sender:coordinadora.seleccionsony@salesupsa.com',1345731492,'2.9991'),(1,'Sender:kshitij@masc.co.in',1345731573,'1.0000'),(1,'Sender:nandha@dynamic.in',1345733798,'1.4708'),(2,'Sender:@dynamic.in',1345733798,'1.4708'),(1,'Sender:sajeevpeelery@yahoo.co.in',1345731992,'1.0000'),(2,'Sender:@yahoo.co.in',1345731992,'1.0000'),(1,'Sender:a290wuc4@md-9.webhostbox.net',1345732020,'1.0000'),(1,'Sender:operacionventassony@salesupsa.com',1345753912,'1.0000'),(1,'Sender:icastillo@salesupsa.com',1345754025,'1.0000'),(1,'Sender:contratacion@salesupsa.com',1345751762,'1.0000'),(1,'Sender:bounces@vlmailer.in',1345732186,'1.0000'),(2,'Sender:@vlmailer.in',1345732186,'1.0000'),(1,'Sender:walterostertor@yahoo.com.sg',1345733117,'1.7731'),(2,'Sender:@yahoo.com.sg',1345742840,'1.0000'),(1,'Sender:patildeepali162@gmail.com',1345732300,'1.0000'),(1,'Sender:info@uk-total-gas.com',1345795441,'1.0000'),(2,'Sender:@uk-total-gas.com',1345795441,'1.0000'),(1,'Sender:srs0=w8xdw8=gx=juaristi.co.in=service@srs.bis7.eu.blackberry.com',1345732432,'1.0000'),(2,'Sender:@srs.bis7.eu.blackberry.com',1345732432,'1.0000'),(1,'Sender:do_not_reply@pay.pw',1345732631,'1.0000'),(2,'Sender:@pay.pw',1345732631,'1.0000'),(1,'Sender:postman@livemailservice.com',1345796135,'1.9081'),(2,'Sender:@livemailservice.com',1345796135,'1.9081'),(1,'Sender:info@crowndigitizing.com',1345790465,'1.0000'),(2,'Sender:@crowndigitizing.com',1345790465,'1.0000'),(1,'Sender:b.cramer@reederei-cramer.de',1345733121,'1.0000'),(2,'Sender:@reederei-cramer.de',1345733121,'1.0000'),(1,'Sender:peter.hoff@used-machines.de',1345733514,'1.0000'),(2,'Sender:@used-machines.de',1345733514,'1.0000'),(1,'Sender:exhibition@tendertiger.com',1345733625,'1.0000'),(2,'Sender:@tendertiger.com',1345757648,'1.0000'),(1,'Sender:scanner@salesupsa.com',1345733682,'1.0000'),(1,'Sender:especialistaaudio@salesupsa.com',1345736896,'1.3905'),(1,'Sender:trainingblr@imtma.in',1345734279,'1.0000'),(2,'Sender:@imtma.in',1345734279,'1.0000'),(1,'Sender:seleccion@salesupsa.com',1345763580,'1.0000'),(1,'Sender:info@zorba.co.in',1345734446,'3.0000'),(2,'Sender:@zorba.co.in',1345734446,'3.0000'),(1,'Sender:mail-teesort-4633-25-212694-mahendra=aaravinfotech.com@optin9.cleanmail.in',1345735418,'1.0000'),(2,'Sender:@optin9.cleanmail.in',1345735418,'1.0000'),(1,'Sender:crossqkr@md-9.webhostbox.net',1345751519,'1.0000'),(1,'Sender:fcastaneda@salesupsa.com',1345735903,'4.9975'),(1,'Sender:costcontrollertalisman@salesupsa.com',1345766501,'1.0000'),(1,'Sender:noreply@freelancer.com',1345787087,'1.0000'),(2,'Sender:@freelancer.com',1345787087,'1.0000'),(1,'Sender:spinzon@salesupsa.com',1345779607,'1.0000'),(1,'Sender:drayala@salesupsa.com',1345750165,'1.9997'),(1,'Sender:direccionadminsony@salesupsa.com',1345751175,'1.0000'),(1,'Sender:erikaliliana.murcia@am.sony.com',1345736849,'1.0000'),(1,'Sender:coordinadorseleccion@salesupsa.com',1345755764,'3.5048'),(1,'Sender:liderneiva@salesupsa.com',1345736956,'1.0000'),(1,'Sender:jobsckkg@md-9.webhostbox.net',1345794429,'1.3372'),(1,'Sender:hans1955@excte.com',1345737153,'1.0000'),(2,'Sender:@excte.com',1345737153,'1.0000'),(1,'Sender:darwis_christianto@yahoo.com',1345737408,'1.0000'),(1,'Sender:info@exxonmobil-gas.com',1345742846,'47.1942'),(2,'Sender:@exxonmobil-gas.com',1345742846,'47.1942'),(1,'Sender:mail-sundarammutual-4081-31-476321-accounts=oriententerprise.co.in@optin8.cleanmail.in',1345737938,'1.0000'),(2,'Sender:@optin8.cleanmail.in',1345737938,'1.0000'),(1,'Sender:lidermonteria@salesupsa.com',1345754698,'1.1728'),(1,'Sender:jorgejuzga@eventsalliance.co',1345769187,'1.0000'),(2,'Sender:@eventsalliance.co',1345769187,'1.0000'),(1,'Sender:auxmercadeohandycam@salesupsa.com',1345759605,'1.0000'),(1,'Sender:supervisorcosta@salesupsa.com',1345739018,'3.9058'),(1,'Sender:amitykhg@md-9.webhostbox.net',1345795376,'3.7625'),(1,'Sender:supervisoroccidente@salesupsa.com',1345773076,'0.1024'),(1,'Sender:humanresourcesdept@uk-total-gas.com',1345740696,'5.4238'),(1,'Sender:claudiojarreta@yahoo.com.br',1345739568,'1.0000'),(2,'Sender:@yahoo.com.br',1345739568,'1.0000'),(1,'Sender:asgharkhan01@hotmail.com',1345739684,'1.0000'),(1,'Sender:xlopez@salesupsa.com',1345766120,'1.0000'),(1,'Sender:seleccionmedellin@salesupsa.com',1345740454,'1.0000'),(1,'Sender:ahmed.maher@xpnet.co',1345743154,'3.8604'),(2,'Sender:@xpnet.co',1345758510,'1.5869'),(1,'Sender:especialistaps@salesupsa.com',1345755696,'4.1590'),(1,'Sender:henry.gorleku@yahoo.com',1345741549,'1.0000'),(1,'Sender:craigwebber@igassociates.org',1345741802,'1.0000'),(2,'Sender:@igassociates.org',1345741802,'1.0000'),(1,'Sender:instructoroccidentedi@salesupsa.com',1345741973,'1.0000'),(1,'Sender:idrian@estrella-apolo-consultores.com',1345745105,'3.6121'),(2,'Sender:@estrella-apolo-consultores.com',1345745105,'3.6121'),(1,'Sender:hantu_hitam301@yahoo.com.sg',1345742840,'1.0000'),(1,'Sender:coastaloiluk@gmail.com',1345742923,'1.0000'),(1,'Sender:supervisorbogota3@salesupsa.com',1345768741,'6.4899'),(1,'Sender:notification+zrdpffopfv6e@facebookmail.com',1345743164,'1.0000'),(2,'Sender:@facebookmail.com',1345755849,'1.0000'),(1,'Sender:itsacrc5@md-9.webhostbox.net',1345743366,'1.0000'),(1,'Sender:projectdirector@al-zadinbingroup.com',1345743641,'1.0000'),(2,'Sender:@al-zadinbingroup.com',1345743641,'1.0000'),(1,'Sender:resdex@naukri.com',1345743791,'1.9908'),(2,'Sender:@naukri.com',1345743791,'1.9908'),(1,'Sender:congresorosarista@urosario.edu.co',1345746375,'6.5537'),(2,'Sender:@urosario.edu.co',1345746375,'6.5537'),(1,'Sender:teach2ew@md-9.webhostbox.net',1345786925,'1.0000'),(1,'Sender:manifibx@md-9.webhostbox.net',1345745488,'1.0000'),(1,'Sender:bestkoki7@gmail.com',1345745840,'1.0000'),(1,'Sender:lidercali1@salesupsa.com',1345746393,'1.9997'),(1,'Sender:s-qsdhnh3f_4bjtamabiotl6mcbsbhxiiaddrjvvpnz9btsgppnqwtlv@bounce.linkedin.com',1345746431,'1.0000'),(1,'Sender:andres_rdn@hotmail.com',1345746947,'1.0000'),(1,'Sender:lidersantamarta@salesupsa.com',1345747025,'1.0000'),(1,'Sender:rami.sadiq@murjanholding.com',1345747117,'1.9997'),(2,'Sender:@murjanholding.com',1345763271,'1.0000'),(1,'Sender:marcebriceno@gmail.com',1345747713,'1.8494'),(1,'Sender:wishnu.dharma@yahoo.com',1345747542,'1.0000'),(1,'Sender:seguridadsocial@salesupsa.com',1345748889,'1.6342'),(1,'Sender:elsehaupt@gmail.com',1345753120,'1.0000'),(1,'Sender:epro-2026-1598-kunal=creative-emarketing.co.in@mail.insideurbox.in',1345748081,'1.0000'),(1,'Sender:senasonyadmin@salesupsa.com',1345749750,'1.0000'),(1,'Sender:drillingengineer@salesupsa.com',1345750013,'1.0000'),(1,'Sender:v.fersouza@gmail.com',1345750931,'1.0000'),(1,'Sender:mostafa.arabi@xpnet.co',1345757023,'1.0000'),(1,'Sender:outletwise@sm16.eaglefly.co.in',1345752292,'1.0000'),(2,'Sender:@sm16.eaglefly.co.in',1345752292,'1.0000'),(1,'Sender:especialistatv@salesupsa.com',1345760022,'1.0000'),(1,'Sender:charmlynsmithsea@gmail.com',1345752517,'1.0000'),(1,'Sender:mprister@hotmail.com',1345752786,'1.0000'),(1,'Sender:sysexeiv@md-9.webhostbox.net',1345753080,'1.0000'),(1,'Sender:lidercartagena@salesupsa.com',1345753317,'1.0000'),(1,'Sender:4q7pza5kqunbpi5iw6owcd2thx1gkfxd-b@bounce.bronto.com',1345753608,'1.0000'),(2,'Sender:@bounce.bronto.com',1345753608,'1.0000'),(1,'Sender:lmartinez@salesupsa.com',1345753921,'1.0000'),(1,'Sender:bounce-b_fi8katchhkmasp63b14t1kseqsn5kvqvo8nvit5eh6tgr44pqqcg====@bounces.livingsocial.com',1345754238,'1.0000'),(2,'Sender:@bounces.livingsocial.com',1345754238,'1.0000'),(1,'Sender:invite+acmftas5zywrpcubtdxjqyw5ob2xkaw5nlmnvbq@facebookmail.com',1345755849,'1.0000'),(1,'Sender:frugtel@ig.com.br',1345755977,'1.0000'),(2,'Sender:@ig.com.br',1345755977,'1.0000'),(1,'Sender:mtm0321@yahoo.com',1345757196,'1.0000'),(1,'Sender:elsehaupturosario@gmail.com',1345757737,'46.5993'),(1,'Sender:freshtenders@tendertiger.com',1345757648,'1.0000'),(1,'Sender:lidercucuta@salesupsa.com',1345776179,'1.0000'),(1,'Sender:mohamed.abdeltawab@xpnet.co',1345758510,'1.0000'),(1,'Sender:analistagestioncomercial@salesupsa.com',1345762524,'1.9878'),(1,'Sender:vsee@vsee.com',1345759162,'1.0000'),(2,'Sender:@vsee.com',1345759162,'1.0000'),(1,'Sender:gerard.butler@immigrationspecialist.org',1345759216,'1.0000'),(2,'Sender:@immigrationspecialist.org',1345759216,'1.0000'),(1,'Sender:pablo@juaristi.com',1345759270,'1.0000'),(2,'Sender:@juaristi.com',1345759270,'1.0000'),(1,'Sender:russell@masc.co.in',1345759600,'1.0000'),(1,'Sender:3wra2uackax0ghk7ier9hh9e7.5hfk3cf7k3fh4be7l.5hf@analytics.bounces.google.com',1345761373,'1.0000'),(2,'Sender:@analytics.bounces.google.com',1345761373,'1.0000'),(1,'Sender:ahmed.abdul@murjanholding.com',1345763271,'1.0000'),(1,'Sender:coordinadorejecafetero@salesupsa.com',1345763615,'10.4356'),(1,'Sender:s-xemfufcxddob3utrwlzdoo6rw_ob36crggms6avnsmwqf2trvffi6p@bounce.linkedin.com',1345763390,'1.0000'),(1,'Sender:lidercali2@salesuppsa.com',1345763523,'1.0000'),(2,'Sender:@salesuppsa.com',1345763523,'1.0000'),(1,'Sender:kettisblow@yahoo.com',1345764443,'1.0000'),(1,'Sender:jpinzon@salesupsa.com',1345765457,'1.9314'),(1,'Sender:epro-2026-1603-kunal=creative-emarketing.co.in@mail.insideurbox.in',1345766187,'1.0000'),(1,'Sender:lazurblue@gmail.com',1345766269,'1.0000'),(1,'Sender:epro-2026-1604-kunal=creative-emarketing.co.in@mail.insideurbox.in',1345767668,'1.0000'),(1,'Sender:instructoroccidenteps@salesupsa.com',1345767971,'1.9556'),(1,'Sender:anshul@goctet.com',1345790070,'1.0000'),(2,'Sender:@goctet.com',1345796870,'7.6900'),(1,'Sender:edna.garzon@am.sony.com',1345772046,'1.0000'),(1,'Sender:rajesh@bhartiyaminternationalschool.com',1345774533,'1.0000'),(1,'Sender:bertjjj@gmail.com',1345775958,'1.0000'),(1,'Sender:nelsonpeter880731@gmail.com',1345777912,'1.0000'),(1,'Sender:chakritton@gmail.com',1345779130,'1.0000'),(1,'Sender:paolitaestrella1012@hotmail.com',1345779372,'1.0000'),(1,'Sender:sophia@yfcad.com',1345779741,'1.0000'),(2,'Sender:@yfcad.com',1345779741,'1.0000'),(1,'Sender:ecorella@maderitas.ec',1345780813,'1.0000'),(2,'Sender:@maderitas.ec',1345780813,'1.0000'),(1,'Sender:kae@phonattic.com',1345786749,'1.3754'),(2,'Sender:@phonattic.com',1345786749,'1.3754'),(1,'Sender:creatplj@md-9.webhostbox.net',1345781570,'1.0000'),(1,'Sender:vaibhav@duflon.com',1345781943,'2.9994'),(2,'Sender:@duflon.com',1345781943,'2.9994'),(1,'Sender:giitrade.com@gmail.com',1345782334,'1.0000'),(1,'Sender:ekaterina@kaskad-travel.ru',1345783091,'1.0000'),(1,'Sender:bounces+332854-d8ba-domains=mezzenger.com@sendgrid.info',1345783372,'1.0000'),(1,'Sender:mumbaifeedback@justdial.com',1345784091,'3.7928'),(2,'Sender:@justdial.com',1345784091,'3.7928'),(1,'Sender:b.uthaiah@macindia.in',1345784931,'1.0000'),(2,'Sender:@macindia.in',1345784931,'1.0000'),(1,'Sender:auxmercadeotv@salesupsa.com',1345785129,'1.0000'),(1,'Sender:religaremf-86-870-267279-accounts=oriententerprise.co.in@optin1.cleanmail.in',1345785143,'1.0000'),(2,'Sender:@optin1.cleanmail.in',1345785143,'1.0000'),(1,'Sender:info@mobiappdevelopers.com',1345785185,'1.0000'),(2,'Sender:@mobiappdevelopers.com',1345785185,'1.0000'),(1,'Sender:raulo.jitendra@gmail.com',1345785472,'1.9881'),(1,'Sender:epro-2026-1606-service=juaristi.co.in@mail.insideurbox.in',1345785942,'1.0000'),(1,'Sender:playnos@hotmail.com',1345786345,'1.9997'),(1,'Sender:bounce@wonderpaperz.in',1345786555,'1.0000'),(2,'Sender:@wonderpaperz.in',1345786555,'1.0000'),(1,'Sender:service@juaristi.co.in',1345788070,'9.5275'),(1,'Sender:rakesh.tiwari@naveenengineering.com',1345787153,'2.9991'),(2,'Sender:@naveenengineering.com',1345787153,'2.9991'),(1,'Sender:geteba3t@md-9.webhostbox.net',1345797035,'2.0000'),(1,'Sender:smsmanpower5@gmail.com',1345788142,'1.0000'),(1,'Sender:mrs.jamilafatima00@ciudad.com.ar',1345788465,'1.9664'),(2,'Sender:@ciudad.com.ar',1345788465,'1.9664'),(1,'Sender:info@opalfloorings.in',1345794548,'1.9997'),(2,'Sender:@opalfloorings.in',1345794548,'1.9997'),(1,'Sender:newsletter@gautamgouthi.in',1345789549,'15.9636'),(2,'Sender:@gautamgouthi.in',1345789549,'15.9636'),(1,'Sender:fan@comptoirsdezoe.com',1345790012,'2.9183'),(2,'Sender:@comptoirsdezoe.com',1345790012,'2.9183'),(1,'Sender:kim_meil@yahoo.com',1345789827,'1.0000'),(1,'Sender:sajidkharodia@yahoo.in',1345790045,'1.0000'),(2,'Sender:@yahoo.in',1345790045,'1.0000'),(1,'Sender:georgeenaj@yahoo.com',1345790229,'1.9997'),(1,'Sender:tuah.mutazar@yahoo.com',1345792039,'1.5275'),(1,'Sender:mailadd@teczeesystems.in',1345790408,'1.0000'),(2,'Sender:@teczeesystems.in',1345790408,'1.0000'),(1,'Sender:thuyhang.ftu.k48@gmail.com',1345790470,'1.0000'),(1,'Sender:prvs=576f2d6c4=rajveersinh.ramlavat@ril.com',1345792016,'1.0000'),(2,'Sender:@ril.com',1345792016,'1.0000'),(1,'Sender:syed.maaz@fedex.com',1345792031,'1.9997'),(2,'Sender:@fedex.com',1345792031,'1.9997'),(1,'Sender:epro-2026-1612-kunal=creative-emarketing.co.in@mail.insideurbox.in',1345792272,'1.0000'),(1,'Sender:teresa.dsouza@eurekaforbes.co.in',1345792319,'1.0000'),(2,'Sender:@eurekaforbes.co.in',1345792319,'1.0000'),(1,'Sender:info@crosssectionmedia.com',1345792707,'1.0000'),(2,'Sender:@crosssectionmedia.com',1345792707,'1.0000'),(1,'Sender:packing@parexindia.com',1345793181,'1.9997'),(1,'Sender:noorhg3w@md-9.webhostbox.net',1345793324,'1.0000'),(1,'Sender:ayaz@faabind.com',1345793414,'4.9977'),(1,'Sender:s.drabek@fum-poreba.pl',1345793452,'1.0000'),(2,'Sender:@fum-poreba.pl',1345793452,'1.0000'),(1,'Sender:support@aaravinfotech.com',1345793663,'1.0000'),(1,'Sender:masih@smartecprefab.com',1345793779,'1.0000'),(2,'Sender:@smartecprefab.com',1345796117,'2.3433'),(1,'Sender:mumbai.if@gmail.com',1345793880,'1.0000'),(1,'Sender:nominaproyectoespecial@salesupsa.com',1345794056,'1.0000'),(1,'Sender:walia.amardeep@interjvg-pipes.com',1345797075,'1.9643'),(2,'Sender:@interjvg-pipes.com',1345797075,'2.4721'),(1,'Sender:postmaster@name-services.com',1345794551,'1.0000'),(2,'Sender:@name-services.com',1345794551,'1.0000'),(1,'Sender:priyanka@interjvg-pipes.com',1345794599,'1.0000'),(1,'Sender:jainname@gmail.com',1345794843,'1.9997'),(1,'Sender:wcard@senatorinternational.in',1345795123,'1.0000'),(2,'Sender:@senatorinternational.in',1345795123,'1.0000'),(1,'Sender:mailman-loop@md-9.webhostbox.net',1345795204,'7.0000'),(1,'Sender:mobia5an@md-9.webhostbox.net',1345795641,'1.0000'),(1,'Sender:epro-2026-1614-service=juaristi.co.in@mail.insideurbox.in',1345795752,'1.0000'),(1,'Sender:epro-2026-1614-kunal=creative-emarketing.co.in@mail.insideurbox.in',1345795827,'1.0000'),(1,'Sender:supteam@directi.con.md-9.webhostbox.net',1345795935,'1.0000'),(2,'Sender:@directi.con.md-9.webhostbox.net',1345796216,'3.8127'),(1,'Sender:supteam1@directi.con.md-9.webhostbox.net',1345796216,'2.8891'),(1,'Sender:raju@smartecprefab.com',1345796117,'1.9803'),(1,'Sender:payment@paypal.com',1345796054,'1.0000'),(2,'Sender:@paypal.com',1345796054,'1.0000'),(1,'Sender:customercare@landmarkinsurance.in',1345796226,'1.0000'),(2,'Sender:@landmarkinsurance.in',1345796226,'1.0000'),(1,'Sender:promote@goctet.com',1345796514,'1.9997'),(1,'Sender:libe.azkuna@lanbi.com',1345796621,'1.0000'),(2,'Sender:@lanbi.com',1345796621,'1.0000'),(1,'Sender:promotion@goctet.com',1345796681,'1.9997'),(1,'Sender:promotions@goctet.com',1345796870,'3.9872'),(1,'Sender:matkinson@bradelytinaandassociates.com',1345796874,'1.0000'),(2,'Sender:@bradelytinaandassociates.com',1345796874,'1.0000');
/*!40000 ALTER TABLE `quotas_tracking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `session_tracking`
--

DROP TABLE IF EXISTS `session_tracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `session_tracking` (
  `Instance` varchar(255) collate latin1_bin default NULL,
  `QueueID` varchar(255) collate latin1_bin default NULL,
  `Timestamp` bigint(20) NOT NULL,
  `ClientAddress` varchar(64) collate latin1_bin default NULL,
  `ClientName` varchar(255) collate latin1_bin default NULL,
  `ClientReverseName` varchar(255) collate latin1_bin default NULL,
  `Protocol` varchar(255) collate latin1_bin default NULL,
  `EncryptionProtocol` varchar(255) collate latin1_bin default NULL,
  `EncryptionCipher` varchar(255) collate latin1_bin default NULL,
  `EncryptionKeySize` varchar(255) collate latin1_bin default NULL,
  `SASLMethod` varchar(255) collate latin1_bin default NULL,
  `SASLSender` varchar(255) collate latin1_bin default NULL,
  `SASLUsername` varchar(255) collate latin1_bin default NULL,
  `Helo` varchar(255) collate latin1_bin default NULL,
  `Sender` varchar(255) collate latin1_bin default NULL,
  `Size` bigint(20) unsigned default NULL,
  `RecipientData` text collate latin1_bin,
  UNIQUE KEY `Instance` (`Instance`),
  KEY `session_tracking_idx1` (`QueueID`,`ClientAddress`,`Sender`),
  KEY `session_tracking_idx2` (`Timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `session_tracking`
--

LOCK TABLES `session_tracking` WRITE;
/*!40000 ALTER TABLE `session_tracking` DISABLE KEYS */;
/*!40000 ALTER TABLE `session_tracking` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2012-08-24  8:32:43
