
/** 
  * Component for monitoring Outgoing Traffic
  *
  * @author Wasif Masood
  * @date   July 11th, 2010
  */ 

configuration AnalyzerC{

	provides interface PacketLoad;
	provides interface RadioAnalyzer;	
}
implementation{

	components AnalyzerP as Imp;
	components new TimerMilliC() as GenTimer,new TimerMilliC() as RadioTimerC;
	components HilTimerMilliC as LocalC;	
	components ActiveMessageC as AM;

	PacketLoad = Imp;
	RadioAnalyzer = Imp;

	Imp.OnTimer -> GenTimer;	
	Imp.RadioTimer -> RadioTimerC;	
	Imp.LocalTime -> LocalC;	
	Imp.Packet -> AM;
	
	#ifdef LOG_ANALYZER
	components SerialLoggerC;
	Imp.SerialLogger -> SerialLoggerC;
	#endif

}
