

/** 
  * Component for monitoring Outgoing Traffic
  *
  * @author Wasif Masood
  * @date   July 11th, 2010
  */ 


#ifndef ANALYZER_H
#define ANALYZER_H


typedef struct traffic_load_msg{
		uint32_t send_bytes;				// for Tx loging
		uint32_t receive_bytes;			// for Rx logging
		uint32_t sent_bytes;				// for actual throughput logging
		uint32_t packetsSend;
		uint32_t packetsLost;	
		uint16_t sendRate;
		uint32_t send_count;
		uint32_t receive_count;
		uint16_t receiveRate;
		uint16_t txErrorRate;
		uint16_t throughputRate;
	}traffic_load_msg_t;

/**Packet types to be used in Analyzer, must start from 2 because 0 and 1 are reserved for MAC**/

// lower indexes are reserved for MAC packets logging
enum packet_types_routing{
	BMAC_MSG = 0,
	S4_BEACON_MSG =5,
	CTP_BEACON_MSG=6,
	S4_DV_MSG =7,
	S4_FWD_MSG = 8,
	S4_APP_MSG = 9,
	CTP_APP_MSG=10,
	CTP_FWD_MSG=11,
	APP_MSG = 12,
};

#endif	
