use std::sync::Mutex;

extern "C" fn callback(mutptr: *const Mutex<bool>) {
    let mutex: &Mutex<bool>;
    unsafe {
        mutex = &*mutptr;
    }
    let mut guard = mutex.lock();
}

#[link(name = "lib")]
extern {
   fn register_callback(target: *const Mutex<bool>,
                        cb: extern fn(*const Mutex<bool>));
   fn trigger_callback();
}

fn main() {
    let mutex: Mutex<bool> = Mutex::new_with_condvars(false, 1);
    unsafe {
        register_callback(&mutex as *const Mutex<bool>, callback);
    }
    let guard = mutex.lock();
    if !*guard {
        guard.cond.wait();
    }
}
