#include <thread>

typedef void (*rust_callback)(void*);
void* cb_target;
rust_callback cb;

extern "C" {

void trigger_callback() {
  cb(cb_target); // Will call callback(&rustObject, 7) in Rust
}

void register_callback(void* callback_target, rust_callback callback) {
    cb_target = callback_target;
    cb = callback;
    std::thread th(trigger_callback);
    th.detach();
}

}
