import itertools
import sys
import threading

def noop_trace(frame, event, arg):
   # no operation
   return noop_trace

print("Enable tracing")
sys.settrace(noop_trace)
threading.settrace(noop_trace)

def callback_generator():
    for counter in itertools.count(1):
        print("Python callback call #%s" % counter)
        yield


def callback():
    if callback._generator is None:
        print("CALLBACK: First call, create the generator")
        callback._generator = callback_generator()
    print("CALLBACK: Call the generator")
    callback._generator.next()
callback._generator = None

import _test
print("Call a Python function in a C thread")
print("")
_test.call_in_c_thread(callback)
print("")
print("Call a Python function in a C thread -- done")

print("Call again in the Python thread")
for test in range(3):
    callback()

