# $OpenBSD$

COMMENT =	package manager for lua ${MODLUA_VERSION}

V =		3.7.0
DISTNAME =	luarocks-${V}
PKGNAME =	luarocks${MODLUA_VERSION}-${V}
CATEGORIES =	devel

HOMEPAGE =	https://luarocks.org/

MAINTAINER =	Omar Polo <op@omarpolo.com>

# MIT
PERMIT_PACKAGE =	Yes

MASTER_SITES =		https://luarocks.org/releases/

MODULES =		lang/lua
MODLUA_SA =		Yes

DESCR =	  		${.CURDIR}/../pkg/DESCR
MESSAGE =		${.CURDIR}/../pkg/MESSAGE
UNMESSAGE =		${.CURDIR}/../pkg/UNMESSAGE
PATCHDIR =		${.CURDIR}/../patches
CHECKSUM_FILE =		${.CURDIR}/../distinfo

RUN_DEPENDS =		archivers/zip \
			net/curl

USE_GMAKE =		Yes

CONFIGURE_STYLE =	simple
CONFIGURE_ARGS =	--with-lua-include=${MODLUA_INCL_DIR} \
			--with-lua-lib=${LOCALBASE}/lib \
			--sysconfdir=${PREFIX}/share/examples/luarocks \
			--lua-version=${MODLUA_VERSION}

NO_TEST =		Yes

PKG_ARCH =		*

post-configure:
	sed -i 's,/usr/bin/env lua,${MODLUA_BIN},g' ${WRKSRC}/src/bin/*

post-install:
	cd ${PREFIX}/bin && \
		mv luarocks luarocks-${MODLUA_VERSION} && \
		mv luarocks-admin luarocks-admin-${MODLUA_VERSION}
