/*-------------------------------------------------------------------------
 *
 * example.c
 *	  Quick and dirty hack
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif

#include "libpq-fe.h"

int
main(int argc, char **argv)
{
	PGconn	   *conn;
	PGresult   *resprepare, *resexecute;

    /*
	const char *keywords[7];
	const char *values[7];

	keywords[0] = "host";
	values[0] = "localhost";
	keywords[1] = "port";
	values[1] = "5432";
	keywords[2] = "user";
	values[2] = "guillaume";
	keywords[3] = "password";
	values[3] = "";
	keywords[4] = "dbname";
	values[4] = "postgres";
	keywords[5] = "fallback_application_name";
	values[5] = "example";
	keywords[6] = NULL;
	values[6] = NULL;

	conn = PQconnectdbParams(keywords, values, true);
    */

    conn = PQconnectdb("host=localhost dbname=postgres");
	if (!conn)
	{
		fprintf(stderr, "Connection to database failed\n");
		return -1;
	}

	if (PQstatus(conn) == CONNECTION_BAD)
	{
		fprintf(stderr, "Connection to database failed:\n%s", PQerrorMessage(conn));
		PQfinish(conn);
		return -1;
	}

    printf ("connection OK\n");

    resprepare = PQprepare(conn, "test", "DELETE FROM v1 WHERE c1 BETWEEN 10 AND 90 RETURNING c1", 0, NULL);
	if (PQresultStatus(resprepare) != PGRES_COMMAND_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resprepare));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resprepare);
		PQfinish(conn);
		return -1;
	}

    printf ("prepare OK\n");

    resexecute =  PQexecPrepared(conn, "test", 0, NULL, NULL, NULL, 0);
	if (PQresultStatus(resexecute) != PGRES_TUPLES_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resexecute));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resexecute);
		PQfinish(conn);
		return -1;
	}

    printf ("execute OK\n");

    printf ("ntuples: %d\n", PQntuples(resexecute));

	PQclear(resprepare);
	PQclear(resexecute);
	PQfinish(conn);

    printf ("cleanup OK\n");

    return 0;
}
