DATA=/mnt/data/pgdata

function initcluster() {
	echo "======== init $1 ========"
	killall postgres >> keybench.log 2>&1
	rm -Rf $DATA >> keybench.log 2>&1
	pg_ctl -D $DATA init >> keybench.log 2>&1
	pg_config >> keybench.log 2>&1
	cp postgresql.conf $DATA
	pg_ctl -D $DATA -l bench.log start >> keybench.log 2>&1
	sleep 5
	createdb test >> keybench.log 2>&1
}

function init() {
	echo "======== scale $1 ========"

        psql -h localhost test -c "drop table if exists stuff_text_asc" >> keybench.log 2>&1

        psql -h localhost test -c "create table stuff_text_asc    as select (random())::text         as randtxt   from generate_series(1,$1) order by randtxt"   >> keybench.log 2>&1

	psql -h localhost test -c "insert into stuff_text_asc select min(randtxt) from stuff_text_asc limit 1" >> keybench.log

	psql -h localhost test -c "analyze"               >> keybench.log 2>&1
	psql -h localhost test -c "vacuum freeze"         >> keybench.log 2>&1
	psql -h localhost test -c "checkpoint"            >> keybench.log 2>&1
}

function query() {
	echo "$1"
	for i in `seq 1 20`; do
		r=`echo "$1" | psql -h localhost test | grep 'Time'`
		echo $r
	done
}

function queries() {

        # text
        query "select percentile_disc(0) within group (order by randtxt) from stuff_text_asc"
        query "select count(distinct randtxt) from stuff_text_asc"
        query "select * from (select * from stuff_text_asc order by randtxt offset 100000000000) foo"

}

initcluster

init 100000
queries

init 1000000
queries

init 2000000
queries

init 3000000
queries

init 4000000
queries

init 5000000
queries
