-- Force report and reset of so far collected statistics,
-- otherwise there is a risk statistics for old transactions will be included
SELECT pg_stat_report_stat();

-- We should have no so far collected statistics, since we haven't done anything yet:
SELECT * FROM pg_stat_transaction_functions ORDER BY funcid;
SELECT * FROM pg_stat_transaction_tables ORDER BY relid;

-- Let's call some functions, which will generate some data activity...
SELECT new_user('joel','secret');
SELECT check_password('joel','secret');
SELECT new_transaction('joel', 'USD', 10000);
SELECT new_transaction('joel', 'USD', -3500);
SELECT get_account_balance('joel', 'USD');

-- And some more functions...
SELECT new_user('claes','qwerty');
SELECT check_password('claes','qwerty');
SELECT new_transaction('claes', 'EUR', 5000);
SELECT new_transaction('claes', 'EUR', -1000);
SELECT new_transaction('claes', 'EUR', 2000);
SELECT get_account_balance('claes', 'EUR');

-- What functions were called during this transaction?
SELECT * FROM pg_stat_transaction_functions ORDER BY funcid;

-- What tables were affected by this transaction?
SELECT * FROM pg_stat_transaction_tables ORDER BY relid;
