#!/usr/bin/env bash

set -x
set -e

PATH_OLD=$PATH
DATADIR1=/mnt/raid-sata/data-1
DATADIR2=/mnt/raid-sata/data-2
DURATION=10

for r in $(seq 1 5); do

	for s in 10 100 1000 10000 100000; do

		for bs in 10 100 1000; do

			if [ $bs -gt $s ]; then
				continue
			fi

			for log in logged unlogged; do

				for build in fdw-master fdw-master-resowner fdw-copy fdw-copy-resowner; do

					export PATH=/home/tomas/builds/$build/bin:$PATH_OLD

					pg_ctl -D $DATADIR1 -l pg-1.log start
					pg_ctl -D $DATADIR2 -l pg-2.log start

					sed "s/BATCH/$bs/" create.sql | psql test >> debug.log 2>&1

					sed "s/SCALE/$s/" generate.template | psql test >> debug.log 2>&1

					sed "s/SCALE/$s/" copy.template > copy.sql

					for c in 1 4 8 16; do

						psql -p 5432 test -c "checkpoint"
						psql -p 5433 test -c "checkpoint"
						psql -p 5433 test -c "truncate t"
						psql -p 5433 test -c "alter table t set $log"

						tps=$(pgbench -n -f copy.sql -c $c -j $c -T $DURATION test | grep 'tps = ' | awk '{print $3}')

						echo $r $s $bs $log $build $c $tps >> results.csv

					done

					pg_ctl -D $DATADIR1 -l pg-1.log stop
					pg_ctl -D $DATADIR2 -l pg-2.log stop

				done

			done

		done

	done

done
