#include "common.h"
#include <signal.h>

//If the key and the certificate are in the same file, these two can be the same
#define CERTFILE "certificates/server.cert.pem"
#define KEYFILE "certificates/server.key.pem"

//One of the two values below can be NULL but not both
#define CAFILE "certificates/ca-chain.cert.pem"
#define CADIR NULL

//These are defined here so that we can do a cleanup in case of a SIGTERM signal
SSL_CTX *ctx = NULL;
BIO *acc = NULL;

void server_error_(const char *msg) ;
void cleanup_(void) ;

//Does the setup of the server (loading SSL libraries, loading certificates, etc)
SSL_CTX *setup_server_ctx_(void) ;

//Exchange of data with the clien
int exchange_data_(SSL *ssl) ;

//Does the whole communication once the connection is established
void communicate_(SSL *ssl) ;

//Waits for clients, establishes the connection and then proceeds to
//call communicate_()
void run_server_(void) ;
