#include "server.h"
#include <sys/time.h>

void server_error_(const char *msg)
{
	int_error(msg);
}

void cleanup_(void)
{
  if(ctx != NULL)
  {
    SSL_CTX_free(ctx);
  }

  if(acc != NULL)
  {
    BIO_free(acc);
  }
}



SSL_CTX *setup_server_ctx_(void)
{
	SSL_CTX *ctx;

	init_OpenSSL();

	//This is my function, gotta investigate it and see what should be there (maybe I got it right?)
	SEED_PRNG_();

	// This specifies that either SSL or TLS can be used
	// Later, we will "filter" out SSLv2
	ctx = SSL_CTX_new(SSL_METHOD_);

	SSL_CTX_set_options(ctx, SSL_CTX_FLAGS_);

	// These two functions are used to load trusted CAs
	if (SSL_CTX_load_verify_locations(ctx, CAFILE, CADIR) != 1)
	{
		server_error_("Setup error: Error loading CA file and/or directory");
	}
	if (SSL_CTX_set_default_verify_paths(ctx) != 1)
	{
		server_error_("Setup error: Error loading default CA file and/or directory");
	}

	// This loads a certificate from a file
	if (SSL_CTX_use_certificate_chain_file(ctx, CERTFILE) != 1)
	{
			server_error_("Setup error: Error loading certificate from file");
	}
	// This loads a private key (can be the same file as certificate)
	if (SSL_CTX_use_PrivateKey_file(ctx, KEYFILE, SSL_FILETYPE_PEM) != 1)
	{
			server_error_("Setup error: Error loading private key from file");
	}
	if (SSL_CTX_set_cipher_list(ctx, CIPHER_LIST) != 1)
	{
		server_error_("Error setting cipher list (no valid ciphers)");
	}
	// Setting the verify options for ctx context
	SSL_CTX_set_verify(ctx, SSL_VERIFY_PEER | SSL_VERIFY_FAIL_IF_NO_PEER_CERT, verify_callback);
	// Setting the maximum allowed depth for CA verification
	SSL_CTX_set_verify_depth(ctx, DEFAULT_DEPTH_);

	return ctx;
}

int exchange_data_(SSL *ssl)
{
	int err;
	err = write_to_SSL(ssl, "Hello, world!", strlen("Hello, world!"));

	if (err <= 0)
	{
		printf("An unsuccessful write!");
	}
	else
	{
		printf("Sent %d bytes.\n", err);
	}

	// SSL_get_shutdown(ssl) & SSL_RECEIVED_SHUTDOWN != 0 indicate that the shutdown notification
	// was sent from the peer (in this case, the client)
	//close(uart_fd);

	return (SSL_get_shutdown(ssl) & SSL_RECEIVED_SHUTDOWN) ? 1 : 0;
}


void communicate_(SSL *ssl)
{
	long err;
	struct timeval tval_before, tval_after, tval_result;
	//accepting connection from ssl object (structure)

	gettimeofday(&tval_before, NULL);
	if (SSL_accept(ssl) <= 0)
	{
		server_error_("Error accepting SSL connection");
	}
	if ((err = post_connection_check(ssl, CLIENT)) != X509_V_OK)
	{
		server_error_("Error checking SSL object after connection-Error: peer certificate");
		//X509_verify_cert_error_string(err) takodje treba iskoristiti
	}
	fprintf(stderr, "SSL Connection opened\n");

	if (exchange_data_(ssl))
	{
		//See this https://www.openssl.org/docs/manmaster/ssl/SSL_shutdown.html
		SSL_shutdown(ssl);
	}
	else
	{
		// https://www.openssl.org/docs/manmaster/ssl/SSL_clear.html
		SSL_clear(ssl);
	}

	gettimeofday(&tval_after, NULL);

	timersub(&tval_after, &tval_before, &tval_result);

	printf("Duration of operation: %lu sec, %lu usec\n", tval_result.tv_sec, tval_result.tv_usec);

	fprintf(stderr, "SSL Connection closed\n");
	SSL_free(ssl);
}


void run_server_(void)
{
	BIO  *client;
	SSL *ssl;

	//This call does the setup of the server context (see the function for more info)
	ctx = setup_server_ctx_();

	// Creates BIO and sets the accept port
	BIO_set_bind_mode(acc, BIO_BIND_REUSEADDR_IF_UNUSED);
	acc = BIO_new_accept(PORT);
	if (!acc)
	{
		server_error_("Error creating server socket");
	}
	//The first call to BIO_do_accept() binds to the given port
	if (BIO_do_accept(acc) <= 0)
	{
		server_error_("Error binding server socket");
	}
	for (;;)
	{
		//The second BIO_do_accept() call listens on the acc BIO
		if (BIO_do_accept(acc) <= 0)
		{
			server_error_("Error accepting connection from client");
		}
		client = BIO_pop(acc);
		if (!(ssl = SSL_new(ctx)))
		{
			server_error_("Error creating SSL context");
		}
		SSL_set_bio(ssl, client, client);
		communicate_(ssl);
	}


}

int main(int argc, char *argv[])
{
	run_server_();
	return 1;
}
