/*
 * Userspace virtual console blanking
 *
 * Copyright (c) 2005 Gene Pavlovsky
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/vermagic.h>
#include <linux/compiler.h>
#include <linux/kmod.h>

#ifndef USER_VC_BLANK_PATH
#define USER_VC_BLANK_PATH "/sbin/user_vc_blank"
#endif

extern int (*console_blank_hook)(int);

static int user_vc_blank(int blank)
{
  char *argv[3], *envp[1], blank_str[16];
  int retval;

#ifdef DEBUG
  printk(KERN_NOTICE "user_vc_blank: user_vc_blank called with blank=%d\n", blank);
#endif
  argv[0] = USER_VC_BLANK_PATH;
  sprintf(blank_str, "%d", blank);
  argv[1] = blank_str;
  argv[2] = 0;
  envp[0] = 0;
  retval = call_usermodehelper(argv[0], argv, envp, 0);
#ifdef DEBUG
  printk(KERN_NOTICE "user_vc_blank: %s returned %d\n", USER_VC_BLANK_PATH, retval);
#endif
  return 1;
}

static int __init user_vc_blank_init(void)
{
#ifdef DEBUG
  printk(KERN_NOTICE "user_vc_blank: module loaded, installing console blank hook\n");
#endif
  console_blank_hook = user_vc_blank;
  return 0;
}

static void __exit user_vc_blank_exit(void)
{
#ifdef DEBUG
  printk(KERN_NOTICE "user_vc_blank: module unloaded\n");
#endif
}

module_init(user_vc_blank_init);
module_exit(user_vc_blank_exit);

MODULE_AUTHOR("Gene Pavlovsky <heilong@bluebottle.com>");
MODULE_DESCRIPTION("Userspace virtual console blanking");
MODULE_LICENSE("GPL");

MODULE_INFO(vermagic, VERMAGIC_STRING);

#undef unix
struct module __this_module
__attribute__((section(".gnu.linkonce.this_module"))) = {
 .name = __stringify(KBUILD_MODNAME),
 .init = init_module,
#ifdef CONFIG_MODULE_UNLOAD
 .exit = cleanup_module,
#endif
};

static const char __module_depends[]
__attribute_used__
__attribute__((section(".modinfo"))) =
"depends=";
