#define likely(x)    __builtin_expect(!!(x), 1)
#define unlikely(x)  __builtin_expect(!!(x), 0)

/* if you're compiling this on a BE system, comment out the following line */
#undef BIG_ENDIAN

#ifndef BIG_ENDIAN
#  define swab16(x) (x)
#  define cpu_to_le16(x) (x)
#else
#  define swab16(x) \
({ \
        uint16_t __x = (x); \
        ((uint16_t)( \
                (((uint16_t)(__x) & (uint16_t)0x00ffU) << 8) | \
                (((uint16_t)(__x) & (uint16_t)0xff00U) >> 8) )); \
})

#  define cpu_to_le16(x) ((__attribute__((force)) __uint16_t)swab16((x)))
#endif


#define noinline __attribute__((noinline))

#ifndef EINVAL
#define EINVAL 1
#endif

#define INFO( mess, ... ) \
do {\
  char buff[1024];\
  sprintf( buff, "[%s::%s (%i)] %s\n", __FILE__, __PRETTY_FUNCTION__,\
           __LINE__, mess );\
  printf( buff, __VA_ARGS__ );\
} while(0)

#define BUGCHK( val, errmess, ... ) \
do {\
  if( val ) {\
    char errbuff[4096];\
    sprintf( errbuff, errmess, __VA_ARGS__ );\
    printf( "[%s::%s (%i)] BUG: %s\n", __FILE__, \
            __PRETTY_FUNCTION__, __LINE__, errbuff );\
    goto err_out;\
  }\
} while(0)
