#include <libsoup/soup.h>
#include <memory.h>

#define PAGE "<html><body>Hello world</body></html>"

static void server_callback(SoupServer *server, SoupMessage *msg, const char *path, GHashTable *query,
                            SoupClientContext *context, gpointer data) {
    soup_message_set_response(msg, "text/html", SOUP_MEMORY_STATIC, PAGE, strlen(PAGE));
    soup_message_set_status(msg, SOUP_STATUS_OK);
}

int main() {
    SoupServer *server;
    server = soup_server_new(NULL, NULL);
    soup_server_add_handler(server, NULL, &server_callback, NULL, NULL);
    soup_server_listen_local(server, 8080, 0, NULL);
    g_main_loop_run(g_main_loop_new(NULL, TRUE));
    return 0;
}