#include "mongoose.h"

#define PAGE "<html><body>Hello world</body></html>"

static const char *s_http_port = "8080";

static void ev_handler(struct mg_connection *nc, int ev, void *p) {
    if (MG_EV_HTTP_REQUEST == ev)
        mg_printf(nc,
                  "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nContent-Length: %zu\r\n\r\n%s", strlen(PAGE), PAGE);
}

int main(void) {
    struct mg_mgr mgr;
    mg_mgr_init(&mgr, NULL);
    mg_set_protocol_http_websocket(mg_bind(&mgr, s_http_port, ev_handler));
    for (;;) {
        mg_mgr_poll(&mgr, 1000);
    }
    mg_mgr_free(&mgr);
    return 0;
}