/*
 * Decompiled with CFR 0.152.
 */
package com.merant.datadirect.jdbc.sqlserver.tds;

import com.merant.datadirect.jdbc.base.BaseWarnings;
import com.merant.datadirect.jdbc.sqlserver.tds.TDSConnection;
import com.merant.datadirect.jdbc.sqlserver.tds.TDSRPCParameter;
import com.merant.datadirect.jdbc.sqlserver.tds.TDSRPCRequest;
import com.merant.datadirect.util.UtilByteOrderedDataReader;
import com.merant.datadirect.util.UtilByteOrderedDataWriter;
import java.sql.SQLException;

public class TDSCursorRequest
extends TDSRPCRequest {
    private static String footprint = "$Revision:   1.7  $";
    String commandText;
    String cursorName;
    int cursorHandle;
    int cursorType;
    int concurrencyOptions;
    int rowsInTable;
    static final int DEFAULT_FETCH_SIZE = 256;
    int fetchSize;
    boolean resultTypeHasBeenRequested;
    boolean executingSQLDirectly;
    TDSRPCParameter cursorHandleParam;
    TDSRPCParameter cursorTypeParam;
    TDSRPCParameter concurrencyOptionsParam;
    TDSRPCParameter rowsInTableParam;

    public TDSCursorRequest(TDSConnection tDSConnection, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string, boolean bl) {
        super(tDSConnection, utilByteOrderedDataReader, utilByteOrderedDataWriter, "");
        this.commandText = string;
        this.cursorName = null;
        this.cursorHandle = -1;
        this.executingSQLDirectly = false;
        this.fetchSize = 256;
        this.reset("sp_cursoropen", 1, 0);
        this.cursorHandleParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        this.cursorHandleParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(0));
        this.addParameter(this.cursorHandleParam);
        TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, new String(string));
        this.addParameter(tDSRPCParameter);
        this.cursorTypeParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        int n = bl ? 4100 : 4;
        this.cursorTypeParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(n));
        this.addParameter(this.cursorTypeParam);
        this.concurrencyOptionsParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        this.concurrencyOptionsParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(8193));
        this.addParameter(this.concurrencyOptionsParam);
        this.rowsInTableParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        this.rowsInTableParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(0));
        this.addParameter(this.rowsInTableParam);
    }

    public void closeCursor(BaseWarnings baseWarnings) throws SQLException {
        this.reset("sp_cursorclose", 1, 0);
        TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(this.cursorHandle));
        this.addParameter(tDSRPCParameter);
        this.submitRequest();
        this.processReply(baseWarnings);
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        if (this.executingSQLDirectly) {
            super.completeRowProcessing(baseWarnings);
        } else {
            this.closeCursor(baseWarnings);
        }
    }

    public boolean getExecutingSQLDirectly() {
        return this.executingSQLDirectly;
    }

    public int getResultType() {
        if (this.executingSQLDirectly) {
            return super.getResultType();
        }
        if (this.resultTypeHasBeenRequested) {
            return 1;
        }
        this.resultTypeHasBeenRequested = true;
        return 2;
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        if (this.executingSQLDirectly) {
            return super.getRow(baseWarnings);
        }
        if (super.getRow(baseWarnings)) {
            return true;
        }
        this.processReply(baseWarnings);
        this.sendCursorFetch(baseWarnings);
        if (super.getRow(baseWarnings)) {
            return true;
        }
        this.processReply(baseWarnings);
        return false;
    }

    public void openCursor(BaseWarnings baseWarnings) throws SQLException {
        this.resultTypeHasBeenRequested = false;
        this.submitRequest();
        this.processReply(baseWarnings);
        if (!this.executingSQLDirectly) {
            this.cursorHandle = (Integer)this.cursorHandleParam.value;
            this.cursorType = (Integer)this.cursorTypeParam.value;
            this.concurrencyOptions = (Integer)this.concurrencyOptionsParam.value;
            this.rowsInTable = (Integer)this.rowsInTableParam.value;
        }
    }

    protected boolean processInfoTokenAction(int n, byte by, byte by2) {
        if (n == 16954) {
            this.executingSQLDirectly = true;
            this.processMode = 2;
            return false;
        }
        return true;
    }

    public void reset(String string, int n, int n2) {
        this.parameters.removeAllElements();
        this.procedureName = string;
        this.processMode = n;
        this.RPCOptions = n2;
    }

    private void sendCursorFetch(BaseWarnings baseWarnings) throws SQLException {
        this.reset("sp_cursorfetch", 2, 2);
        this.numRowsFetchedFromResultSet = 0;
        TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(this.cursorHandle));
        this.addParameter(tDSRPCParameter);
        tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(2));
        this.addParameter(tDSRPCParameter);
        tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(1));
        this.addParameter(tDSRPCParameter);
        tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(this.fetchSize));
        this.addParameter(tDSRPCParameter);
        this.submitRequest();
        if (this.conn.getTDSVersion() == 2) {
            this.processReply(baseWarnings);
        }
        this.resultType = 2;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n > 0 ? n : 256;
    }
}

