-------------------------------------------------------------------------------
-- $Id: VirtexNetlist.hs,v 1.23 2000/01/20 18:24:32 satnam Exp $
-------------------------------------------------------------------------------

module VirtexNetlist
where

import Netlist
import Array
import Gates
import TypeExpr
import Tile
import LUTs
import LavaClasses
import IOExts
import Utils
import BitVec

-------------------------------------------------------------------------------

addLut1 fn i           = add1Gate    (Lut1 (lut1_init fn)) i
addLut2 fn i0 i1       = add2Gate (Lut2 (lut2_init fn)) i0 i1
addLut3 fn i0 i1 i2    = add3Gate      (Lut3 (lut3_init fn)) i0 i1 i2
addLut4 fn i0 i1 i2 i3 = add4Gate      (Lut4 (lut4_init fn)) i0 i1 i2 i3

-------------------------------------------------------------------------------

instance Stream (SignalA String) where
  bitvec2ints v = []
  to_bitvec bv = []
  
instance Spacers (StateST a) where
  addSpace = addSpaceNL  

instance Combinational (StateST a) (SignalA String) where
  gate1 f i = addLut1 f i
  gate2 f (i0,i1) = addLut2 f i0 i1
  gate3 f (i0,i1,i2) = addLut3 f i0 i1 i2
  gate4 f (i0,i1,i2,i3) = addLut4 f i0 i1 i2 i3
  rom16x1 = rom16x1_netlist
  xorcy (li, ci) = addGate Xorcy [("li",li),("ci",ci)] "o"
  muxcy (s, (di,ci)) = addGate Muxcy [("di",di),("ci",ci),("s",s)] "o"
  muxf5 (s, (i0,i1)) = addUnplacedGate MuxF5 [("s",s),("i0",i0),("i1",i1)] "o" 
  muxf5_l (s, (i0,i1)) = addUnplacedGate MuxF5_L [("s",s),("i0",i0),("i1",i1)] "lo"
  muxf6 (s, (i0,i1)) = addUnplacedGate MuxF6 [("s",s),("i0",i0),("i1",i1)] "o"
  muxf6_l (s, (i0,i1)) = addUnplacedGate MuxF6_L [("s",s),("i0",i0),("i1",i1)] "lo"
  gnd = do (clk,clr,zero,one) <- getGlobals
           (if zero == UndefinedVar then
             do z <- addUnplacedGate Gnd [] "g"
                setGlobals (clk,clr,z,one)
                return z
            else
              return zero)
  vcc = do (clk,clr,zero,one) <- getGlobals
           (if one == UndefinedVar then
             do z <- addUnplacedGate Vcc [] "p"
                setGlobals (clk,clr,zero,z)
                return z
            else
              return one)
  buf i = addGate Buf [("i",i)] "o"
  fd c d = addGate Fd [("d",d), ("c",c)] "q"
  fdc c clr d = addGate Fdc [("d",d), ("c",c), ("clr",clr)] "q"
  delayBit _ d = do (clk, clr, zero, one) <- getGlobals
                    addGate Fd [("d",d), ("c", clk)] "q"
  delayBus n ds = sequence [delayBit undefined d | d <- ds]

-------------------------------------------------------------------------------

rom16x1_netlist iv [a0,a1,a2,a3] 
  = addGate (Rom16x1 (bools2int iv)) 
    [("a0",a0), ("a1",a1), ("a2",a2), ("a3",a3)] "o"
rom16x1_netlist iv addr
  = error ("rom16x1 NL: address should be four bits: " ++ show addr ++ "\n")
  
-------------------------------------------------------------------------------

instance Loop (StateST a) (SignalA String)  where    
  loop = loopNetList 
  loopList = loop5bL

-------------------------------------------------------------------------------
  
instance Combinators (StateST a) where
  putBeside = putBesideNL
  putBelow = putBelowNL
  putOver = putOverNL
  swapTiles = swapTilesNL
  tile = tileNL

instance Circuit (StateST a) (SignalA String)

-------------------------------------------------------------------------------

instance Show (StateST a (SignalA String)) where
  showsPrec _ a = undefined 


instance Show (StateST a [SignalA String]) where
  showsPrec _ a = undefined 

-------------------------------------------------------------------------------
 
add1Gate :: Cell -> BitSignal -> StateST state BitSignal 
add1Gate cell i0
  = addGate cell [("i0",i0)] "o"

-------------------------------------------------------------------------------

add2Gate :: Cell -> BitSignal -> BitSignal -> StateST state BitSignal 
add2Gate cell i0 i1
  = notrace ("Adding " ++ show cell ++ "\n")
          (addGate cell [("i0",i0),("i1",i1)] "o") 

-------------------------------------------------------------------------------

add3Gate :: Cell -> BitSignal -> BitSignal -> BitSignal ->
            StateST state BitSignal
add3Gate cell i0 i1 i2
  = addGate cell [("i0",i0),("i1",i1),("i2",i2)] "o"
  
-------------------------------------------------------------------------------

add4Gate :: Cell -> BitSignal -> BitSignal -> BitSignal -> BitSignal ->
            StateST state BitSignal
add4Gate cell i0 i1 i2 i3
  = addGate cell [("i0",i0),("i1",i1),("i2",i2),("i3",i3)] "o"

-------------------------------------------------------------------------------

type BitFeedBack state a b = ((a, SignalA String) -> StateST state (b, SignalA String))

loopNetList :: Show a => BitFeedBack state a b -> a -> StateST state b
loopNetList circuit a
  = loop5b circuit a
  
-------------------------------------------------------------------------------

--loop2a :: Monad m => Pointers s -> ((a,c) -> m (b,c)) -> a -> m (b,c) 
loop2a cir pointers input
  = (\ f -> do ~(_, feedback) <- f
               let StateST circuit = cir (input, feedback)
               outfd <- circuit pointers 
               return outfd) 
    (loop2a cir pointers input)   
      
--loop2b :: Monad m => Pointers s -> ((a,c) -> m (b,c)) -> a -> m b
loop2b circuit input
  = StateST (\pointers ->  do ~(f,_) <- loop2a circuit pointers input
                              return f
            )



-------------------------------------------------------------------------------

 
loop4a cir pointers input
  = (\ f -> do l_ <-  f
               -- let ~(_, feedback) = xxx
               let StateST circuit = cir (input, Var "f")
               outfd <- circuit pointers 
               return outfd) 
    (loop4a cir pointers input)   
      

loop4b circuit input
  = StateST (\pointers ->  do ~(f,_) <- loop4a circuit pointers input
                              return f)
                              
-------------------------------------------------------------------------------

loop5a cir pointers input
  =  do feedback <- newBitVar pointers
        let StateST circuit = cir (input, feedback)
        ~(output, fB) <- circuit pointers 
        connectBit pointers fB feedback
        return output  
      

loop5b circuit input
  = StateST (\pointers -> loop5a circuit pointers input)

-------------------------------------------------------------------------------

loop5aL :: Int -> ((a,[SignalA String]) -> StateST state (b, [SignalA String])) ->
           Pointers state -> a -> ST state b
loop5aL n cir pointers input
  =  do feedbacks <- sequence (replicate n (newBitVar pointers))
        let StateST circuit = cir (input, feedbacks)
        ~(output, fBs) <- circuit pointers 
        sequence_ [connectBit pointers fB feedback | (fB, feedback) <-
                   zip fBs feedbacks]
        return output  
      

loop5bL :: Int -> ((a,[SignalA String]) -> 
           StateST state (b, [SignalA String])) -> a -> StateST state b 
loop5bL n circuit input
  = StateST (\pointers -> loop5aL n circuit pointers input)


-------------------------------------------------------------------------------
            