-------------------------------------------------------------------------------
-- $Id: VHDL.hs,v 1.12 2000/01/23 03:30:15 satnam Exp $
-------------------------------------------------------------------------------

module VHDL (circuit2VHDL)
where
import Lava
import VirtexNetlist
import Array
import EDIF
import IOExts
import Verilog

-------------------------------------------------------------------------------

circuit2VHDL :: String -> (forall state . StateST state a) -> IO ()
circuit2VHDL name circuit
  = do putStr ("Generating VHDL    " ++ filename ++ "...")
       -- showNetListToFile name circuit
       writeFile filename (unlines (vhdlEntity name intf))
       vhdlArchitecture filename name instCount netCount instances 
       putStrLn ""
       -- circuit2Verilog name nl
       circuit2EDIF name nl 
    where
    nl@(instCount, netCount, intf, globals, instances) = evaluateSTCir circuit
    filename = name ++ ".vhd" 

-------------------------------------------------------------------------------

vhdlEntity name intf
  = ["library ieee ;",
     "use ieee.std_logic_1164.all ;",
     "entity " ++ name ++ " is ",
     "  port(" ++ vhdlPorts (reverse intf)] ++
    ["      ) ;",
     "end entity " ++ name ++ " ;",
     ""]
     
-------------------------------------------------------------------------------

vhdlPorts intf
  = insertString " ;\n       " (map vhdlPort intf) 
  
vhdlPort (Port dir name typ)
  = name ++ " : " ++ showMode dir ++ " " ++ showType typ

showType BitType = "std_logic"
showType (BitVector a dir b)
  = "std_logic_vector (" ++ show a ++ " " ++ showDir dir ++ " " ++ show b
    ++ ")"
    
showDir To = "to"
showDir Downto = "downto"

-------------------------------------------------------------------------------


vhdlArchitecture filename name instCount netCount instances
  = do appendFile filename 
        (unlines ["library ieee, unisim ;",
          "use ieee.std_logic_1164.all ;",
          "use unisim.vcomponents.all ;",
          "architecture lava of " ++ name ++ " is ",
          "  signal lava : std_logic_vector (0 to " ++ show (netCount-1) ++ ") ;",
          "begin"])
       vhdlInstances filename instances instCount 0
       appendFile filename "end architecture lava ;\n"

-------------------------------------------------------------------------------

vhdlInstances filename instances nrInst i | nrInst == i
  = return ()
vhdlInstances filename instances nrInst i
  = do appendFile filename ((vhdlInstance i (instances!i) ++ "\n"))
       vhdlInstances filename instances nrInst (i+1) 

-------------------------------------------------------------------------------

vhdlInstance i (Unused, _, _, _) = ""
vhdlInstance i (cell, pos, prop, ports)
  = "  " ++ showCell cell ++ "_" ++ show i ++ " : " ++ showCell cell ++
    vhdlGenerics prop ++
    " port map (" ++ insertString ", " (vhdlArgs ports) ++ ") ;"

-------------------------------------------------------------------------------

vhdlArgs = map vhdlArg
 
-------------------------------------------------------------------------------

vhdlArg (PortMap dir arg par)
  = arg ++ " => " ++ vhdlSignal par

-------------------------------------------------------------------------------

vhdlSignal (Var v) = v
vhdlSignal (LavaSig n) = "lava(" ++ show n ++ ")"
vhdlSignal (ArrayElement typ name idx) = (vhdlSignal name) ++ "(" ++ show idx ++ ")" 
vhdlSignal UndefinedVar = notrace ("Warning: undefined variable.\n") "UndefinedVar"
vhdlSignal other = error ("vhdlSignal: " ++ show other)

-------------------------------------------------------------------------------

vhdlGenerics [] = []
vhdlGenerics xs
  = " generic map (" ++ insertString ", " (map vhdlGeneric xs) ++ ")"

-------------------------------------------------------------------------------

vhdlGeneric (InitialBV s iv)
  = "init => \"" ++ showBV (reverse (i2bv s iv)) ++ "\""
vhdlGeneric other = ""

-------------------------------------------------------------------------------
             
