-------------------------------------------------------------------------------
-- $Id: Utils.hs,v 1.4 2000/01/20 18:24:32 satnam Exp $
------------------------------------------------------------------------------

module Utils
where


import List
import Char

--------------------------------------------------------------------------------

insertString :: String -> [String] -> String
insertString _ [] = []
insertString s str = foldl1 (insertString' s) str
insertString' s x y = x ++ s ++ y

--------------------------------------------------------------------------------

insertCommas = insertString ", "

--------------------------------------------------------------------------------

insertDots = insertString "."

--------------------------------------------------------------------------------

makeUpperCase :: String -> String
makeUpperCase str = [if isLower ch then toEnum (fromEnum ch - caseDiff)
                     else ch | ch <- str]

--------------------------------------------------------------------------------

makeLowerCase :: String -> String
makeLowerCase str = [if isUpper ch then toEnum (fromEnum ch + caseDiff)
                     else ch | ch <- str]

--------------------------------------------------------------------------------

caseDiff :: Int
caseDiff = (fromEnum 'a') - (fromEnum 'A')

--------------------------------------------------------------------------------

stripSuffix :: String -> String -> String
stripSuffix suffix s 
  = if (take l (reverse s)) == reverse suffix then
      take (length s - l) s 
    else
      s
    where
    l = length suffix

--------------------------------------------------------------------------------

dirPrefix :: String -> String
dirPrefix dirSpec
  = if '/' `elem` dirSpec then
      reverse (dropWhile ((/=)'/') (reverse dirSpec))
    else
      ""

--------------------------------------------------------------------------------

filenameRoot :: String -> String
filenameRoot dirSpec
  = if '/' `elem` dirSpec then
      reverse (takeWhile ((/=)'/') (reverse dirSpec))
    else
      dirSpec


-------------------------------------------------------------------------------

indent_line n line = replicate n ' ' ++ line
indent n  = map (indent_line n) 

-------------------------------------------------------------------------------

insert_semicolons = insert_in_lines " ;"
insert_commas = insert_in_lines " ,"

-------------------------------------------------------------------------------


insert_in_lines str [] = []
insert_in_lines str [a] = [a]
insert_in_lines str (a:b:rest) = (a++str) : insert_in_lines str (b:rest)

-------------------------------------------------------------------------------

pad_with v n l
  = l ++ replicate (n - length l) v

-------------------------------------------------------------------------------

chop n [] = []
chop n l = (take n l) : chop n (drop n l)

-------------------------------------------------------------------------------

notrace :: String -> a -> a
notrace _ x = x

-------------------------------------------------------------------------------

checkTake :: Show a => String -> Int -> [a] -> [a]
checkTake str n l
  = if n < 0 then
      error ("checkTake: " ++ str ++ ": " ++ show n ++ " of " ++ show l)
    else
      take n l
      
-------------------------------------------------------------------------------

log2 :: Int -> Int
log2 n = log2' n 0

log2' n p 
  = if 2^p >= n then
      p
    else
      log2' n (p+1)
      
-------------------------------------------------------------------------------

bitsrequired :: Integral num => num -> Int
bitsrequired n
  = if n < 0 then
      1 + bitsrequired (abs n)
    else
      countbits n

countbits n
  = if n `div` 2 == 0 then
      1
    else
      1 + countbits (n `div` 2)
      
-------------------------------------------------------------------------------
 
