-------------------------------------------------------------------------------
-- $Id: SplitMultiplier.hs,v 1.19 2000/01/21 17:51:17 satnam Exp $
-------------------------------------------------------------------------------

module SplitMultiplier (kcm_top, comb_kcm_top, splitKCM, combinationalKCM)
where
import Lava
import Virtex
import VirtexLib
import IOExts
import KCMUtils

-------------------------------------------------------------------------------

-- A Split-Multiplier KCM [Normal]

-- This is the top level instance of the pipelined KCM.

kcm_top :: Integral num => Bool -> num -> Int -> Int ->
              StateST state ()
kcm_top dataSigned k kSize  dataSize
  = do clk <- globalClock "c"
       d <- inputVec "a" (bit_vector (dataSize-1) downto 0)
       p <- splitKCM dataSigned k kSize d
       outputVec p "prod" (bit_vector (dataSize+kSize-1) downto 0)
    where

-------------------------------------------------------------------------------

-- A Split-Multiplier KCM [Normal]


-- This is the top level instance of the combinational KCM.

comb_kcm_top :: Integral num => Bool -> num -> Int -> Int ->
              StateST state ()
comb_kcm_top dataSigned k kSize  dataSize
  = do d <- inputVec "a" (bit_vector (dataSize-1) downto 0)
       p <- combinationalKCM dataSigned k kSize d
       outputVec p "prod" (bit_vector (dataSize+kSize-1) downto 0)  

-------------------------------------------------------------------------------

fourBitMultiplier :: (Integral num, Circuit nsi bit) =>
                     num -> Int -> [bit] -> nsi ([bit], Bool)
fourBitMultiplier coief coief_width addr
  = do zero <- gnd
       let padded_addr = addr ++ (replicate padding zero)
       r <- rom16x (coief_width+nr_addrs)
                    multiplication_results padded_addr
       return (notrace ("multrel = " ++ show multiplication_results)
              (r, signed_result))  
    where
    multiplication_results 
      = pad_with 0 16 [coief * i | i <- [0..2^nr_addrs-1]]
    nr_addrs = length addr
    padding = 4-nr_addrs
    signed_result = coief < 0


-------------------------------------------------------------------------------

signedFourBitMultiplier :: (Integral num, Circuit nsi bit) =>
                     num -> Int -> [bit] -> nsi ([bit], Bool)
signedFourBitMultiplier coief coief_width addr
  = do zero <- gnd
       let padded_addr = addr ++ (replicate padding zero)
       r <- rom16x (coief_width+nr_addrs) multiplication_results padded_addr
       return (notrace ("signedmultrel = " ++ show multiplication_results) (r, True))  
    where
    multiplication_results 
      = pad_with 0 16 [coief * aAddr | aAddr <- aAddrs]
    -- aAddrs = [0..7] ++ map negate (reverse [1..8])
    aAddrs = [sbv2i (i2bv nr_addrs i) | i <- [0..2^nr_addrs-1]]                
    nr_addrs = length addr
    padding = 4-nr_addrs


     
-------------------------------------------------------------------------------

-- A pipelined split-multiplier KCM
splitKCM :: (Integral num, Circuit nsi bit) =>
                   Bool -> num -> Int -> [bit] -> 
                   nsi [bit]              
splitKCM signed_data coief coief_width addr 
  = do let chopped_addr = chop 4 addr
       let chops = length chopped_addr 
       -- Build the lookup tables for the partial products
       let last_lut = if signed_data then
                          signedFourBitMultiplier
                      else
                          fourBitMultiplier
       let luts = replicate (chops-1) fourBitMultiplier ++ [last_lut]  
       let regluts = hpar [mult4 coief coief_width >|> fsT register |
                           mult4 <- luts] 
       (w, s, product) <- (regluts >-> 
                           insertWeights >-> 
                           pipeTree reg3 weightedAdder) 
                           chopped_addr
       return product
    where
    addr_size = length addr
    -- The weights are a sequence [0,4,8,...] which indicate how much
    -- a group of bits has been shifted by 
    weights = [4*i | i <- [0..]]
    insertWeights pp
      = notrace ("pp:\n" ++ showPPs pp) 
        (return [(w,s,p) | ((p,s),w) <- zip pp weights])
    signed_coief = coief < 0
    signed_result = signed_coief || signed_data


-------------------------------------------------------------------------------

combinationalKCM :: (Integral num, Circuit nsi bit) =>
                    Bool -> num -> Int -> [bit] -> 
                    nsi [bit]
combinationalKCM signed_data coief coief_width addr 
  = do let chopped_addr = chop 4 addr
       let chops = length chopped_addr 
       -- Build the lookup tables for the partial products
       let last_lut = if signed_data then
                          signedFourBitMultiplier
                      else
                          fourBitMultiplier
       let luts = replicate (chops-1) fourBitMultiplier ++ [last_lut]  
       let lutsK = hpar [mult4 coief coief_width | mult4 <- luts] 
       (w, s, product) <- (lutsK >->
                           insertWeights >-> 
                           tree weightedAdder) 
                           chopped_addr
       return product
    where
    addr_size = length addr
    -- The weights are a sequence [0,4,8,...] which indicate how much
    -- a group of bits has been shifted by 
    weights = [4*i | i <- [0..]]
    insertWeights pp
      = notrace ("pp:\n" ++ showPPs pp) 
        (return [(w,s,p) | ((p,s),w) <- zip pp weights])
    signed_coief = coief < 0
    signed_result = signed_coief || signed_data
 
-------------------------------------------------------------------------------

-- Test the 4-bit multiplier.

kcm4_6_50Top
  = do addr <- inputVec "a" (bit_vector 3 downto 0)
       (product, s) <- fourBitMultiplier 50 6 addr
       outputVec product "p" (bit_vector 9 downto 0) 


kcm4_6_50nl = circuit2VHDL "kcm4_6_50" kcm4_6_50Top 


sig4mult_sim1 = stream2signedint result
                where
                inputs = intStream 4 [-8..7]
                result = (signedFourBitMultiplier (-50) 6 >-> proj1) inputs
                
m1=sig4mult_sim1                


-------------------------------------------------------------------------------
