module Main
where

import Lava
import Virtex
import VirtexLib
import MotorolaKCM
import TestSplitMultiplier
import System      

main = do args <- getArgs
          kcm_main args

kcm_main ["-regtest"] = splitMultiplierRegressionTests
kcm_main ["-v"] = showVersion
kcm_main ["-version"] = showVersion
kcm_main ["-h"] = usage
kcm_main ["-help"] = usage
kcm_main [coief_value_str, sign_str, input_size_str]
  = do putStrLn ("Motorola KCM Generator [" ++ version ++ "]")
       putStrLn ("Coefficient: " ++ show coief ++ " (" ++
                 show coief_size ++ "-bits)")
       putStrLn ("Data       : " ++ show data_size ++ "-bits " ++
                 tail (sign_str))
       putStrLn ("Latency    : " ++ show (mot_latency data_size) ++ " ticks")
       circuit2VHDL filename netCir
       putStrLn "Done."
    where
    netCir :: StateST state ()
    netCir = motkcm_top dataSigned coief coief_size data_size
    dataSigned = if sign_str == "-unsigned" then
                   False
                 else
                  if sign_str == "-signed" then
                    True
                 else
                   error ("Sign should be either -sign or -unsigned.\n")
    coief :: Integer 
    coief = read coief_value_str
    coief_size :: Int
    coief_size = bitsrequired coief
    data_size :: Int
    data_size = read input_size_str
    filename = "kcm_" ++ showK coief ++ showSign (coief < 0) ++ "_" ++
                show data_size ++ showSign dataSigned
    showK n = if n < 0 then
               "minus_" ++ show (abs n)
              else
                show n
    showSign signed = if signed then
                        "s"
                      else
                        "u" 


kcm_main other = usage

usage
  = putStrLn ("Usage: motkcm coeif [-unsigned | -signed] data_size")

-------------------------------------------------------------------------------


kcm1 = kcm_main ["2047", "-unsigned", "12"]
kcm2 = kcm_main ["2047", "-unsigned", "4"]
kcm3 = kcm_main ["2047", "-unsigned", "6"]

-------------------------------------------------------------------------------

version = "Beta A 21 January 2000"

-------------------------------------------------------------------------------

showVersion
  = putStrLn ("motkcm version " ++ version)

-------------------------------------------------------------------------------


