-------------------------------------------------------------------------------
-- $Id: LavaClasses.hs,v 1.25 2000/01/20 18:24:31 satnam Exp $
-------------------------------------------------------------------------------

-- This module provides the basic Lava classes.

module LavaClasses 
where
import Tile
import BitOps

-------------------------------------------------------------------------------

-- This module specifies the core functions of a layout system
-- for Lava. For layout interpretations the class members are
-- bound to suitable layout functions. For other kinds of
-- interpretations these class methods are bound to degenerate
-- definitions which do not perform any layout calculations.
-- The module Layout defines an actual layout system suitable
-- for Xilinx's Virtex FPGAs.

-------------------------------------------------------------------------------

class Stream bit where
  bitvec2ints, signed_bitvec2ints :: Num num => [bit] -> [num]
  to_bitvec :: bit -> [Bool]
  
  
class Monad nsi => Spacers nsi where  
  addSpace :: Int -> Int -> nsi ()
  addSpace x y = return () 
  
class Spacers t => Combinational t bit where
  -- gate1, gate2, gate3 and gate4 implement n-input logic functions
  -- using a look-up table.
  gate1 :: (Bool -> Bool)  -> bit -> t bit 
  gate2 :: (Bool -> Bool -> Bool)
           -> (bit, bit) -> t (bit)
  gate3 :: (Bool -> Bool -> Bool -> Bool)
           -> (bit, bit, bit) -> t bit
  gate4 :: (Bool -> Bool -> Bool -> Bool -> Bool)
           -> (bit, bit, bit, bit) 
           -> t (bit)
  rom16x1 :: [Bool] -> [bit] -> t bit
  -- power and ground constant values
  gnd, vcc :: t (bit)
  -- buffer for bit identity and I/O buffers
  buf, ibuf, obuf :: (bit) -> t (bit)
  -- xorcy and muxcy provide access to the carry chain on Virtex FPGAs
  xorcy :: (bit, bit) -> t (bit)
  muxcy, muxf5, muxf5_l, muxf6, muxf6_l :: (bit, (bit, bit)) -> t (bit)
  muxf5 = muxcy
  muxf5_l = muxcy
  muxf6 = muxcy
  muxf6_l = muxcy          
  delayBit :: Bool -> bit -> t bit
  delayBus :: Int -> [bit] -> t [bit]
  fd :: bit -> bit -> t bit 
  fdc :: bit -> bit -> bit -> t bit
  intConstant :: Int -> Int -> t [bit]


 
    


class Loop t bit where
  loop :: Show a => ((a, bit) -> t (b, bit)) -> 
          a -> t b
  loopList :: Int -> ((a, [bit]) -> t (b, [bit])) ->
              a -> t b 

class AbolishedLoop2 t where
  loop2 :: (Show (t a), Show (t b)) => (t (a, loopBack) -> t (b, loopBack)) -> 
          t a -> t b
  
-------------------------------------------------------------------------------

class Monad t => Combinators t where
  evaluateAndTile :: (a -> t b) -> a -> t (b, [tile])
  putBeside :: Tile -> Tile -> t ()
  putBelow  :: Tile -> Tile -> t ()
  putOver   :: Tile -> Tile -> t ()
  -- Tile management
  pushTile :: t ()
  popTile :: t Tile
  swapTiles :: t ()
  tile :: (a -> t b) -> a -> t (b, Tile)
  -- The default is to do nothing.
  tile circuit input = do result <- circuit input
                          return (result, ((0,0),[]))
  pushTile = return ()
  swapTiles = return ()
  evaluateAndTile f a
     = do b <- f a
          return (b, [])
  putBeside _ _ = return ()
  putBelow _ _ = return ()
  putOver _ _ = return ()
  
-------------------------------------------------------------------------------

class (Combinational t bit,
       Stream bit,
       Loop t (bit),
       Show bit,
       Combinators t) => Circuit t bit   

-------------------------------------------------------------------------------

        