-------------------------------------------------------------------------------
-- $Id: LUTs.hs,v 1.1 1999/12/08 01:41:34 satnam Exp $
-------------------------------------------------------------------------------

module LUTs
where

lut1_init :: (Bool -> Bool) -> Int
lut1_init f
  = sum [let [i0] = int2bools 1 i in if f i0 then  2^i else 0 
         | i <- [0..1]]

lut2_init :: (Bool -> Bool -> Bool) -> Int
lut2_init f
  = sum [let [i0, i1] = int2bools 2 i in if f i0 i1 then  2^i else 0 
         | i <- [0..3]]


lut3_init :: (Bool -> Bool -> Bool -> Bool) -> Int
lut3_init f
  = sum [let [i0, i1, i2] = int2bools 3 i 
         in if f i0 i1 i2 then  2^i else 0 
         | i <- [0..7]]
         
lut4_init :: (Bool -> Bool -> Bool -> Bool -> Bool) -> Int
lut4_init f
  = sum [let [i0, i1, i2, i3] = int2bools 4 i 
         in if f i0 i1 i2 i3 then  2^i else 0 
         | i <- [0..15]]

int2bools 0 _ = []
int2bools n v
  = (if v `mod` 2 == 0 then
       False
     else
       True) : int2bools (n-1) (v `div` 2)