-------------------------------------------------------------------------------
-- $Id: SplitMultiplier.hs,v 1.19 2000/01/21 17:51:17 satnam Exp $
-------------------------------------------------------------------------------

module KCMUtils (latency, reg3, showPPs, divB, weightedAdder)
where
import Lava
import Virtex
import VirtexLib
import IOExts
 

-------------------------------------------------------------------------------

latency :: Int -> Int
latency dataSize
  =  1 + log2 (dataSize `divB` 4)

-------------------------------------------------------------------------------

reg3 :: Circuit nsi bit => (a, b, [bit]) -> nsi (a, b, [bit])
reg3 (a,b,c)
  = do creg <- register c
       return (a,b,creg)

-------------------------------------------------------------------------------

showPPs :: Stream bit => [([bit], Bool)] -> String
showPPs = unlines . map showPP

showPP :: Stream bit => ([bit], Bool) -> String
showPP (pp, False)
  = show ipp ++ " unsigned #" ++ show (length pp)
    where
    ipp = bitvec2ints pp
showPP (pp, True)
  = show ipp ++ " signed #" ++ show (length pp)
    where
    ipp = signed_bitvec2ints pp
    
-------------------------------------------------------------------------------


divB a b
  = if a `mod` b == 0 then
      a `div` b
    else
      a `div` b + 1    

-------------------------------------------------------------------------------

weightedAdder :: Circuit nsi bit =>
                 ((Int, Bool, TwosComplement bit), 
                  (Int, Bool, TwosComplement bit)) ->
                 nsi (Int, Bool, TwosComplement bit)  
-- Reorganise the weights to ensure weight1 >= weight2
weightedAdder ((weight1, s1, a1), (weight2, s2, a2)) | weight1 < weight2
  = weightedAdder ((weight2, s2, a2), (weight1, s1, a1))
weightedAdder ((weight1, s1, a1), (weight2, s2, a2))
  = do (lower, (part_sum, resultSign))
         <- par2 buffer mixedSignAdder (lower_bits, ((a1,s1), (a2Upper,s2)))
       return (weight2, resultSign, lower ++ part_sum)   
    where
    weight_difference = weight1 - weight2 
    lower_bits = checkTake "weightedAdder" weight_difference a2
    a2Upper = drop weight_difference a2  
    buffer = par (replicate n buf)
    n = length lower_bits

-------------------------------------------------------------------------------

