module Experiment
where
import BitVec
import List
import Trace

-------------------------------------------------------------------------------

-- Integer Level counter circuit.

delay i = 1966:i

counterCore :: ([Int],[Int]) -> ([Int],[Int])
counterCore (as,bs) 
  = (r,r)
    where
    r = delay [a+b | (a,b) <- zip as bs]
    
loop circuit input
  = let (output, feedback) 
           = circuit (input, feedback)
    in output
        
counter = loop counterCore   
  
-------------------------------------------------------------------------------

-- Loop with data constructor over stream.

data M x = M x
           deriving (Eq, Show)

loopM circuit (M input)
  = let M (output, feedback) = circuit (M (input, feedback))
    in M output
    
counterm = loopM counterCoreM

counterCoreM (M (as, bs))
  = M (counterCore (as, bs))      
  
m1 :: M [Int]
m1 = M (repeat 1)  

r1 = let M x = counterm m1 in take 10 x

-------------------------------------------------------------------------------

-- Classes for circuit descriptions.

class CircuitConstants bit where
  zero :: bit
  
class CircuitConstants bit => Circuit stream bit where
  inv :: stream bit -> stream bit
  and2 :: (stream bit, stream bit) -> stream bit
  exor2 :: (stream bit, stream bit) -> stream bit
  delayBit :: stream bit -> stream bit
  add :: ([stream bit], [stream bit]) -> [stream bit] 

-------------------------------------------------------------------------------

-- An instance for bools.

instance CircuitConstants Bool where
  zero = False

instance Circuit [] Bool where
  inv = map not
  and2 (as, bs) = [a && b | (a,b) <- zip as bs]
  exor2 (as, bs) = [a `xor` b | (a,b) <- zip as bs]
  delayBit s = zero:s
  add (as, bs) = trace "z" (addB (as, bs))
  
-------------------------------------------------------------------------------

addB (as, bs) = bs
addB (as, bs) = transpose 
                 [addBits a b | (a,b) <- zip (transpose as) (transpose bs)]
  
-------------------------------------------------------------------------------

-- Check stream addition.

l1 = [1,2,3,4]
l2 = [4,5,6,7]

i2s s = transpose [int2bitvec' 8 n | n <- s]

s2i s = map bools2int (transpose  s)

t1 = s2i (add (i2s l1, i2s l2))  

-- t1 = [5,7,9,11]

-------------------------------------------------------------------------------

-- Check delayed stream addition

l2d = delayBits (i2s l2)
t2 = s2i (add (i2s l1, l2d))

-- t2 = [1,6,8,10]

-------------------------------------------------------------------------------

-- Check laziness.

l2u = [x : repeat undefined | x <- int2bitvec' 8 3]

c1 = add (i2s l1, l2u)

t3 = s2i (takeStream 1 c1) 

-- l2u = 3 : [undefined, undefined, ...]

-- t3 = [4]

-------------------------------------------------------------------------------

takeStream n stream = [take n s | s <- stream]

-------------------------------------------------------------------------------

xor a b = not (a == b)
  
nandGate (a, b) = inv (and2 (a, b))  
  
r2 = nandGate ([True],[False])
    
    
fork2 a = trace "f" (a, a)    

-------------------------------------------------------------------------------

toggleCore (cntrl, feedback) = fork2 (delayBit (exor2 (cntrl, feedback)))   

-------------------------------------------------------------------------------

toggle :: Circuit stream bit => stream bit -> stream bit
toggle = loop toggleCore

-------------------------------------------------------------------------------

r3 = take 10 (toggle constOne)

-------------------------------------------------------------------------------

constOne = repeat True

-------------------------------------------------------------------------------

counterbitscore :: Circuit stream bit => 
                   ([stream bit], [stream bit]) -> 
                   ([stream bit], [stream bit])
counterbitscore (by, feedback)
 = trace "x" (fork2 (delayBits (add (by, feedback))))

-------------------------------------------------------------------------------

part1 (by, feedback) = add (by, feedback)

-------------------------------------------------------------------------------

counterbits :: Circuit stream bit => [stream bit] -> [stream bit]
counterbits = loopL counterbitscore

delayBits :: Circuit stream bit => [stream bit] -> [stream bit]
delayBits x = trace "p" (map delayBit x)

ones = i2s (replicate 20 1)
twos = i2s (replicate 20 2)

r4 = takeStream 10 (counterbits ones)  
  
r5 = let (as,bs) = (counterbitscore (ones, twos))
     in (s2i as, s2i bs)
      
r6 = s2i (takeStream 10 (part1 (ones, twos)))
     
reg3 x = delayBits (delayBits (delayBits x))     

-------------------------------------------------------------------------------

counterCore2 :: ([Int], ([Int], [Int])) -> ([Int], ([Int], [Int]))
counterCore2 (as, ~(bs,cs)) 
  = (x, (x,x))
    where
    x = (delay [a+b+c | (a,b,c) <- zip3 as bs cs])

-------------------------------------------------------------------------------

counter2 = loop counterCore2

-------------------------------------------------------------------------------

r7 = counter2 [1,2,3,4,5] 

-------------------------------------------------------------------------------

counterCore3 :: ([Int], [Int]) -> ([Int], [Int])
counterCore3 (as, bs) 
  = (x, x)
    where
    x = (delay [a+b | (a,b) <- zip as bs])

-------------------------------------------------------------------------------

counter3 = loop counterCore3

-------------------------------------------------------------------------------

r8 = counter3 [1,2,3,4,5] 

-------------------------------------------------------------------------------

counterCore4 :: ([Int], [[Int]]) -> ([Int], [[Int]])
counterCore4 (as, ~[bs,cs]) 
  = (x, [x,x])
    where
    x = (delay [a+b+c | (a,b,c) <- zip3 as bs cs])

-------------------------------------------------------------------------------

counter4 = loop counterCore4

-------------------------------------------------------------------------------

r9 = counter4 [1,2,3,4,5] 

-------------------------------------------------------------------------------

loopP circuit input
  = output
    where
    (output, (a,b)) = circuit (input, (a,b))

-------------------------------------------------------------------------------

loopL :: ((a, [b]) -> (c, [b])) -> a -> c 
loopL circuit input
  = trace (show l) output
    where
    (output, bs) = circuit (input, as)
    as = [bs!!n | n <- idcs]
    l = length bs
    idcs = [0..l-1]   

-------------------------------------------------------------------------------

         