-------------------------------------------------------------------------------
-- $Id: BitClass.hs,v 1.1 1999/11/29 00:54:44 satnam Exp $
-------------------------------------------------------------------------------

module BitClass
where

-- This module defines a class that describes types can be
-- be used to represent bits.

-------------------------------------------------------------------------------

class BitClass bit where
  low, high :: bit
  bit2bool :: bit -> Bool
  bool2bit :: Bool -> bit

-------------------------------------------------------------------------------

-- An instance of the BitClass is provided for booleans:

instance BitClass Bool where
  low = False
  high = True
  bit2bool = id
  bool2bit = id

-------------------------------------------------------------------------------
