#! /bin/bash

if [ -e /etc/sgi-admin-node-release ]; then
	echo "whoops don't run this on admin node."
	exit 1
fi

mkdir -p /tmp/mnt1
mkdir -p /tmp/i1

echo "rw NFS mount:"
mount -n -o rw,noatime,nolock,tcp,vers=3 172.23.255.232:/cm_shared/image/images_rw_nfs /tmp/mnt1

IMAGENAME=rhel8.0

if [ -z "$RW_SPARSE_PERHOST_SIZE" ]; then
        RW_SPARSE_PERHOST_SIZE="500M"
fi

echo "checking if xfs-test.img exists"
if [ ! -r /tmp/mnt1/$HOSTNAME/$IMAGENAME/xfs-test.img ]; then
        cmd="truncate -s $RW_SPARSE_PERHOST_SIZE /tmp/mnt1/$HOSTNAME/$IMAGENAME/xfs-test.img"
        echo "Creating sparse image on RW NFS path to hold FS image, cmd: $cmd"
        $cmd
	if [ $? -ne 0 ]; then
		echo "Error running truncate command for NEW RW NFS Image!"
		exit 1
	fi

        cmd="mkfs.xfs -f /tmp/mnt1/$HOSTNAME/$IMAGENAME/xfs-test.img"
        echo "Creating XFS filesystem on sparse image on RW NFS path, cmd: $cmd"
        $cmd
	if [ $? -ne 0 ]; then
		echo "Error creating XFS Filesystem on top of RW NFS Image!"
		exit 1
	fi
else
	echo "Image file reported as existing!: $(ls -l /tmp/mnt1/$HOSTNAME/$IMAGENAME/xfs-test.img)"
        cmd="truncate -s $RW_SPARSE_PERHOST_SIZE /tmp/mnt1/$HOSTNAME/$IMAGENAME/xfs-test.img"
        echo "Ensuring size is current for XFS Image on RW NFS, cmd: $cmd"
        $cmd
	if [ $? -ne 0 ]; then
		echo "Error running truncate command for EXISTING RW NFS Image!"
		exit 1
	fi
fi


cmd="mount -o loop /tmp/mnt1/$HOSTNAME/$IMAGENAME/xfs-test.img /tmp/i1"
echo "Mounting XFS Image that resides on RW NFS, cmd: $cmd"
$cmd
if [ $? -ne 0 ]; then
        echo "Error: loopback mounting of XFS Image failed. See above"
        exit 1
fi


cmd="xfs_growfs /tmp/i1"
echo "Growing the filesystem if needed, cmd: $cmd"
$cmd
if [ $? -ne 0 ]; then
	echo "Error: growfs command failed."
	exit 1
fi

