I'll search for information about philosophers working on metaphor-adjacent concepts to provide you with a comprehensive list of both seminal and contemporary thinkers in this area.Based on my research, I can now provide you with a comprehensive list of seminal and contemporary philosophers working on metaphor-adjacent concepts. You're correct that Carnap, Neurath, and Quine provide an incomplete philosophical foundation for metaphor theory, and there are many other important thinkers in this area.

## Seminal Philosophers on Metaphor and Related Concepts

### Classical Foundations
- **Aristotle** - Established foundational concepts in the Poetics, defining metaphor as "giving the thing a name that belongs to something else; the transference being either from species to genus, or from genus to species, or from species to species, on the grounds of analogy"
- **Immanuel Kant** - His theory of schematism influenced later phenomenological approaches to metaphor, particularly through his representation of experience as "the subjective determination of an objective world"
- **Friedrich Nietzsche** - Developed early ideas about the "metaphorization" of thought that influenced later Continental philosophers

### Mid-20th Century Analytic Tradition
- **Max Black** - Developed influential "interaction theory" of metaphor, arguing that metaphorical meaning arises from interaction between words within sentences, introducing the notion of metaphorical sense
- **Donald Davidson** - Argued against metaphorical meaning, locating metaphor instead in the use of sentences rather than in special metaphorical senses of words
- **Nelson Goodman** - Made significant contributions to aesthetics and philosophy of language, exploring metaphor's role in symbolic systems and artistic representation
- **John Searle** - Developed pragmatic approaches to metaphor, arguing that metaphorical sentences are not ambiguous but require understanding the gap between sentence meaning and speaker meaning

### Continental Philosophy Tradition
- **Martin Heidegger** - Saw metaphoric language as signaling "a totality or field of significance in which being discloses or reveals itself"
- **Paul Ricoeur** - Developed extensive phenomenological theories of metaphor, arguing that "metaphor is living" as "the principle which revives our perception of the world and through which we become aware of our creative capacity for seeing the world anew"
- **Jacques Derrida** - In "White Mythology," argued that philosophical concepts are fundamentally metaphorical, and that "the movement of metaphor is the movement of genesis of philosophical concepts"

## Contemporary Philosophers and Theorists

### Cognitive Linguistics and Philosophy of Mind
- **George Lakoff** - Co-founder of conceptual metaphor theory, arguing that metaphors are "part and parcel of everyday thought and linguistic activity" and ground abstract concepts in concrete physical domains
- **Mark Johnson** - Lakoff's frequent collaborator in developing embodied cognition approaches to metaphor
- **Mark Turner** - Co-developer with Gilles Fauconnier of conceptual blending theory, arguing that conceptual blending is "a fundamental instrument of the everyday mind"
- **Gilles Fauconnier** - Co-developed conceptual integration/blending theory, describing it as "a general cognitive operation on a par with analogy, recursion, mental modeling, conceptual categorization, and framing"

### Contemporary Analytic Philosophy
- **Eva Feder Kittay** - Developed sophisticated semantic theories of metaphor, introducing the concept of "second-order meaning" and arguing for metaphor's cognitive significance
- **Ted Cohen** - Made major contributions to metaphor study, particularly in his 2008 book "Thinking of Others: On the Talent for Metaphor," arguing that "the ability to think of one thing as another is an essential human capacity that makes sound moral judgment possible"
- **Josef Stern** - Developed quasi-indexical theories of metaphor, offering alternatives to both interaction and Davidsonian approaches
- **Roger White** - Contemporary critic of traditional approaches to metaphor in analytic philosophy

### Interdisciplinary Contemporary Figures
- **Zoltán Kövecses** - Leading contemporary metaphor theorist who has extended conceptual metaphor theory, known for comprehensive introductions to metaphor studies and recent work on "Extended Conceptual Metaphor Theory"
- **Raymond Gibbs Jr.** - Prominent critic and developer of metaphor theories, particularly focused on experimental approaches and critiques of blending theory

### Philosophy of Science and Metaphor
- **Clive Cazeaux** - Contemporary philosopher examining relationships between metaphor, art, and science against the backdrop of modern European philosophy

The email exchanges you've shared touch on many of these philosophical traditions, particularly the tension between formal/logical approaches (represented by Carnap and Quine) and more embodied, metaphor-centric approaches (represented by Lakoff and Hofstadter). Contemporary phenomenological theories directly challenge straightforward theories of reference, "replacing the ordinary propositional truth based on denotation with a theory of language which designates and discloses its referents", which helps explain why interdisciplinary perspectives from neuroscience, linguistics, and psychology have become essential for grounding metaphor theory in cognitive and embodied foundations.

