Based on the email corpus, I can outline the competing positions on whether formal theories should be considered primary or first-order artifacts with genuine ontological status.

## The Case FOR Formal Theories as First-Order Artifacts (Eric's Position)

**Emergence Through Simulation Creates New Reality**
Eric argues that even if formal logical systems emerge through simulation by more primitive associative mechanisms (like those in brains), they achieve genuine artifact status once they come into existence. As he puts it: "if the simulation brings into existence something whose organization (deliberation with characteristics of logic and symbol-addressable content) has a compact description fully different-in-kind from that of the primitives, I don't think one gets to deny that the new architecture has come into existence as a thing-in-itself in the world."

**Causal Efficacy in the World**
Formal theories do real work—they guide scientific practice, enable predictions, and shape how researchers approach problems. Eric notes how Maxwell's field equations led Einstein to construct general relativity, suggesting these formal structures have genuine causal power beyond mere data compression. The fact that particle physicists felt "liberation" when they could abandon the Particle Data Book for QCD demonstrates that formal theories restructure entire fields of inquiry.

**Irreducible Organizational Properties**
When deliberative, logical processes emerge from associative substrates, they exhibit organizational properties that cannot be reduced back to their primitive origins. Eric argues these symbolic systems, "even if just learned and used as deliberative sequences in private thought, have about the same artifact-status as the un-willed natural phenomena in the world."

**Historical Efficacy**
The historical record shows formal theories guiding scientific discovery in ways that transcend their original empirical contexts. Thermodynamics, originally tied to steam engines, now explains "why there even are stable macro-worlds" across virtually all domains of physics.

## The Case AGAINST Formal Theories as First-Order Artifacts (Glen's Position)

**Fundamental Dependency on Binding**
Glen emphasizes that formal, "unbound/a-semantic terms are not metaphorical terms"—they are essentially empty vessels that only gain meaning through their binding to concrete domains. Without such binding, they lack the substantive content necessary for first-order ontological status. They remain tools within our extended phenotype rather than primary constituents of reality.

**Context-Dependent Reality**
The apparent "reality" of formal theories depends entirely on the richness of the contexts in which they're embedded. Glen notes that when "the 2 contexts (person modeling in the source domain & person modeling in the target domain) aren't equivalently rich, then 'explanation' fails." This suggests formal theories are secondary artifacts that emerge from and depend upon more fundamental contexts.

**Translation vs. Ontology**
When formal systems are transferred across domains, Glen argues this represents translation or mapping rather than the movement of first-order entities. These are "games" that may have value when they "bind well to the world" but lack independent reality when they don't.

**The Open Universe Condition**
Glen's deflationary view appears to rest on the assumption that the universe remains *open* in a crucial sense: any theory or formalism that becomes established as a "frozen" scaffold or conceptual plateau can, in principle, be progressively dissolved and re-grown. This ongoing revisability prevents formal theories from achieving the kind of ontological closure that would make them first-order artifacts. They remain part of our extended cognitive toolkit—powerful and essential, but always potentially subject to fundamental reconceptualization.

## The Deeper Philosophical Stakes

This disagreement connects to fundamental questions about:

- **Ontological Hierarchy**: Are formal structures discovered features of reality or constructed tools within our extended phenotype?
- **Emergence vs. Reduction**: Can higher-order organizational properties achieve genuine autonomy from their substrates?
- **Temporal Ontology**: Does the ongoing possibility of dissolution prevent formal theories from achieving first-order status?

Eric's position aligns with a kind of emergentist realism where formal structures, once instantiated, become primary features of reality. Glen's position suggests that in an open universe, formal structures remain forever revisable elements of our extended cognitive phenotype—sophisticated tools that can be dissolved and regrown as our understanding evolves.

The debate ultimately hinges on whether one believes that organizational patterns can achieve sufficient stability and causal independence to transcend their status as tools, or whether the fundamental openness of inquiry keeps them perpetually secondary to the more basic processes of binding, context-creation, and conceptual reconstruction.

