# Contemporary Domains and Scholars for Metaphor Theory

Based on the corpus analysis and search results, here are the key domains beyond philosophy that are essential for developing a comprehensive theory of metaphor, along with leading contemporary scholars in each field:

## 1. Cognitive Neuroscience

**Essential for:** Understanding the neural substrates of metaphor processing, brain mapping of conceptual metaphors, and neural evidence for embodied cognition.

### Key Contemporary Scholars:
- **Vittorio Gallese** - Pioneer in mirror neuron research and embodied simulation theory; collaborates with Lakoff on neural theory of language
- **Jerome Feldman** - Developer of Neural Theory of Language and Thought (NTTL) 
- **Seana Coulson** - Leading researcher in electrophysiology of metaphor understanding and neurocognitive approaches to figurative language
- **Vicky Lai** - Studies neural mechanisms of metaphor comprehension and cross-linguistic metaphor processing
- **John Anderson** - Develops neural reuse theories relevant to conceptual mappings

## 2. Cognitive Linguistics and Psycholinguistics

**Essential for:** Empirical investigation of metaphor in language use, cross-linguistic studies, and experimental validation of theoretical claims.

### Key Contemporary Scholars:
- **Zoltán Kövecses** - Leading contemporary metaphor theorist, developer of Extended Conceptual Metaphor Theory
- **Gerard Steen** - Developer of Metaphor Identification Procedure (MIP) and deliberate metaphor theory
- **Teenie Matlock** - Researcher in fictive motion and mental simulation in language processing
- **Lera Boroditsky** - Studies how metaphors shape reasoning about time, space, and abstract concepts
- **Jordan Zlatev** - Pioneer in cognitive semiotics and integration of embodiment with semiotic theory

## 3. Experimental Psychology

**Essential for:** Testing predictions of metaphor theories, investigating individual differences, and developmental trajectories.

### Key Contemporary Scholars:
- **Raymond W. Gibbs Jr.** - Leading experimental researcher in metaphor comprehension and embodied cognition
- **Daniel Casasanto** - Studies embodied cognition, metaphor, and cross-linguistic differences in conceptual representation
- **Seana Coulson** - Experimental work on conceptual blending and neural correlates of metaphor
- **Jens Hellmann** - Researcher on embodied metaphors and their cognitive effects
- **Herbert Colston** - Studies irony, metaphor, and pragmatic aspects of figurative language

## 4. Developmental Psychology

**Essential for:** Understanding how metaphor comprehension develops, what cognitive abilities scaffold metaphorical thinking, and cross-cultural developmental patterns.

### Key Contemporary Scholars:
- **Rebecca Zhu** - Studies preschoolers' metaphor comprehension and learning from metaphors
- **Alison Gopnik** - Research on children's conceptual development and analogical reasoning
- **Simona Di Paola** - Studies metaphor development in typical and atypical populations
- **Nausicaa Pouscoulous** - Investigates early metaphor understanding and pragmatic development
- **Serena Lecce** - Studies relationships between theory of mind and metaphor skills in development

## 5. Computational Cognitive Science and AI

**Essential for:** Modeling metaphor processing, testing theoretical predictions computationally, and developing AI systems that can understand metaphor.

### Key Contemporary Scholars:
- **Tony Veale** - Computational creativity and metaphor generation in AI systems
- **Ekaterina Shutova** - Natural language processing approaches to metaphor identification and interpretation
- **Rebecca Hicke** - Recent work on using Large Language Models for computational metaphor research
- **Dedre Gentner** - Structure-mapping theory and computational models of analogy
- **Keith Holyoak** - Analogical reasoning and computational approaches to metaphor

## 6. Anthropological Linguistics

**Essential for:** Cross-cultural studies of metaphor, linguistic relativity effects, and cultural variation in metaphorical systems.

### Key Contemporary Scholars:
- **Penelope Brown** - Cross-linguistic studies of spatial metaphors and cultural cognition
- **Stephen Levinson** - Spatial cognition, linguistic relativity, and cross-cultural cognitive research
- **John Lucy** - Reformulation of linguistic relativity hypothesis and empirical cross-linguistic studies
- **Asifa Majid** - Cross-cultural studies of sensory language and metaphor
- **Caleb Everett** - Linguistic relativity and cultural influences on cognition

## 7. Clinical Psychology and Psychiatry

**Essential for:** Understanding how metaphor functions in mental health, therapy, and psychopathology; exploring embodied aspects of psychological disorders.

### Key Contemporary Scholars:
- **Tim Bayne** - Philosophy of mind and consciousness, metaphor in psychopathology
- **Matthew Broome** - Phenomenological approaches to psychiatry and metaphor in mental illness
- **Jennifer Hansen** - Metaphor in psychotherapy and clinical practice
- **Paula Niedenthal** - Embodied emotion and metaphorical understanding of psychological states

## 8. Discourse Analysis and Pragmatics

**Essential for:** Understanding how metaphors function in real communicative contexts, their social and political effects, and pragmatic aspects of metaphor use.

### Key Contemporary Scholars:
- **Paul Chilton** - Political discourse analysis and metaphor in political communication
- **Andreas Musolff** - Metaphor in political and media discourse
- **Lynne Cameron** - Dynamic approaches to metaphor in discourse and conversation
- **Elena Semino** - Metaphor in healthcare communication and discourse analysis
- **Ruth Wodak** - Critical discourse analysis and metaphor in political contexts

## 9. Cognitive Semiotics

**Essential for:** Integrating embodied cognition with sign theory, understanding metaphor as a semiotic phenomenon, and bridging cognitive and cultural approaches.

### Key Contemporary Scholars:
- **Per Aage Brandt** - Cognitive semiotics and mental space theory
- **Line Brandt** - Blending theory and semiotic approaches to meaning
- **Jordan Zlatev** - Founder of cognitive semiotics as a field
- **Göran Sonesson** - Pictorial semiotics and cognitive approaches to signs

## 10. Philosophy of Mind and Cognitive Science

**Essential for:** Theoretical foundations of metaphor theory, consciousness and metaphor, and integration with broader theories of mind.

### Key Contemporary Scholars:
- **Andy Clark** - Extended mind thesis and embodied cognition
- **Alva Noë** - Enactive approaches to consciousness and perception
- **Shaun Gallagher** - Embodied cognition and phenomenology
- **Mark Johnson** - Continuing work on embodied meaning and aesthetics
- **Elisabeth Camp** - Philosophy of metaphor and figurative language

## Integration Challenges

The corpus reveals that developing a comprehensive metaphor theory requires addressing several integration challenges:

1. **Bridging levels of analysis** - from neural mechanisms to cultural patterns
2. **Reconciling universality and variation** - understanding what aspects of metaphor are universal vs. culturally specific  
3. **Connecting developmental and adult competence** - how early metaphor abilities relate to sophisticated adult reasoning
4. **Integrating embodiment and abstraction** - how bodily grounding enables abstract thought
5. **Balancing computational and phenomenological approaches** - mechanistic models vs. lived experience

The scholars and domains listed above represent the contemporary landscape needed to address Eric and Glen's fundamental question about whether formal theories can be grounded in metaphor-based cognition, and whether metaphor truly goes "all the way down" in human thought.