%define version	0.70
%define encrypt_version 2.14
%define release 0.1cae
%define perl_version %(rpm -q --qf '%%{epoch}:%%{VERSION}' perl)
%define libname_orig gaim-remote
%define libmajor 0
%define libname %mklibname %libname_orig %libmajor
%define __libtoolize /bin/true

Summary: 	A GTK+ based multiprotocol instant messaging client
Name: 		gaim
Version: 	%{version}
Release: 	%{release}
Epoch:		1
Group: 		Networking/Instant messaging
License: 	GPL
Url: 		http://gaim.sourceforge.net
BuildRoot: 	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

Source: 	http://download.sourceforge.net/gaim/%{name}-%{version}.tar.bz2
#Source1: 	%{name}_icons.tar.bz2
Source2:	http://gaim-encryption.sourceforge.net/%{name}-encryption-%{encrypt_version}.tar.bz2
BuildRequires:	autoconf2.5
BuildRequires:	automake1.7
BuildRequires:	audiofile-devel
BuildRequires:	gettext-devel
BuildRequires:	libao-devel
BuildRequires:	libgtk+2-devel
Buildrequires:	libgtkspell-devel >= 2.0.2
BuildRequires:	nas-devel
BuildRequires:	openssl-devel
Buildrequires:	perl-devel
# encrypt plugin
BuildRequires:  libnss3-devel
BuildRequires:  nspr-devel 
# kerberos support in zephyr (can't compile for now -- Abel)
#BuildRequires:	krb5-devel
BuildRequires: ImageMagick
BuildConflicts:	gettext-devel >= 0.12
Requires: 	perl-base = %{perl_version}
Requires:	%{libname} = %{version}-%{release}
Obsoletes:	hackgaim <= 0.60
Provides:	hackgaim <= 0.60

%description
Gaim allows you to talk to anyone using a variety of messaging  
protocols, including AIM (Oscar and TOC), ICQ, IRC, Yahoo!,
MSN Messenger, Jabber, Gadu-Gadu, Napster, and Zephyr.  These
protocols are implemented using a modular, easy to use design.  
To use a protocol, just load the plugin for it.

Gaim supports many common features of other clients, as well as many
unique features, such as perl scripting and C plugins.

Gaim is NOT affiliated with or endorsed by AOL.


%package -n %{libname}
Summary:	Library for providing remote control ability for gaim
Group: 		Networking/Instant messaging
Provides:	lib%{libname_orig} = %{version}-%{release}

%description -n %{libname}
GAIM can be remotely controlled through third-party applications or
through gaim-remote tool. This library must be installed if you want
the above function.


%package -n %{libname}-devel
Summary:	Development files for gaim-remote
Group:		Development/GNOME and GTK+
Provides:	lib%{libname_orig}-devel = %{version}-%{release}
Requires:	%{libname} = %{version}-%{release}

%description -n %{libname}-devel
This package contains development files needed for developing or
compiling applications that need gaim remote control functions.


%prep

%setup -q
#%patch0 -p1 -b .smiley

#tar --bzip2 -xf %{SOURCE1}
tar --bzip2 -xf %{SOURCE2}

%build
# needed by patch2
#WANT_AUTOCONF_2_5=1 autoheader
#aclocal-1.7 -I .
#automake-1.7 -a -c -f
#WANT_AUTOCONF_2_5=1 autoconf

%configure2_5x \
	--enable-nas \              
#	--with-krb4=/usr

%make
# encrypt plugin
cd %{name}-encryption-%{encrypt_version}
%configure2_5x \
	--with-gaim=.. \
	--with-nspr-includes=%{_includedir}/mozilla-1.4/nspr \
        --with-nss-includes=%{_includedir}/mozilla-1.4/nss
%make

%install
%makeinstall_std

#icons
mkdir -p %buildroot/%_miconsdir \
	 %buildroot/%_liconsdir \
	 %buildroot/%_iconsdir
#install -m 644 %{name}_16.png %buildroot/%{_miconsdir}/%{name}.png
#install -m 644 %{name}_32.png %buildroot/%{_iconsdir}/%{name}.png
#install -m 644 %{name}_48.png %buildroot/%{_liconsdir}/%{name}.png
install -m755 licq2gaim.pl %buildroot/%{_bindir}/licq2gaim
convert pixmaps/gaim.png -geometry 48x48 %{buildroot}%{_liconsdir}/%{name}.png
convert pixmaps/gaim.png -geometry 32x32 %{buildroot}%{_iconsdir}/%{name}.png
convert pixmaps/gaim.png -geometry 16x16 %{buildroot}%{_miconsdir}/%{name}.png

# Menu
(cd $RPM_BUILD_ROOT
mkdir -p %buildroot/%_menudir
cat > %buildroot/%_menudir/%{name}  <<EOF
?package(%{name}): command="soundwrapper %_bindir/%{name}" needs="X11" \
icon="%{name}.png" section="Networking/Instant messaging" \
title="Gaim" longtitle="Instant Messenger suporting AIM (Oscar and TOC), ICQ, IRC, Yahoo!, MSN Messenger, Jabber, Gadu-Gadu, Napster, and Zephyr protocols."
EOF
)

%{find_lang} %{name}

# encrypt plugin
cd %{name}-encryption-%{encrypt_version}
%makeinstall_std
mkdir gaim-encrypt
for i in NOTES CHANGELOG TODO VERSION README WISHLIST ; do
	cp $i gaim-encrypt/ ;
done

# remove files not bundled
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/*.a


%post
%{update_menus} 

%postun
%{clean_menus}  

%post -n %{libname} -p /sbin/ldconfig
%postun -n %{libname} -p /sbin/ldconfig

%files -f %{name}.lang
%defattr(-,root,root)
%doc doc/CREDITS doc/FAQ doc/*.txt
%doc AUTHORS ChangeLog COPYING HACKING NEWS README
%doc %{name}-encryption-%{encrypt_version}/gaim-encrypt/
%{_bindir}/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/*
%{_datadir}/sounds/%{name}
%{_libdir}/%{name}
%{_mandir}/*/*
%{_menudir}/*
%{_miconsdir}/%{name}.png
%{_iconsdir}/%{name}.png
%{_liconsdir}/%{name}.png

%files -n %{libname}
%defattr(-,root,root)
%{_libdir}/lib*.so.*
%{_libdir}/perl5/vendor_perl/5.8.1/i386-linux-thread-multi/Gaim.pm
%{_libdir}/perl5/vendor_perl/5.8.1/i386-linux-thread-multi/auto/Gaim/*

%files -n %{libname}-devel
%defattr(-,root,root)
%{_includedir}/*
%{_libdir}/lib*.so
%{_libdir}/lib*.la


%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Sun Oct 05 2003 Charles A Edwards <eslrahc@bellsouth.net> -0.70-0.1cae
- 0.70
- drop Source1
- update source2 and add URL
- drop smiley patch
- drop patch2 calls as unnedded
- buildrequire ImageMagick

* Wed Sep 03 2003 Laurent Culioli <laurent@pschit.net> 0.68-1mdk
- gaim 0.68
- gaim-encryption 2.10

* Tue Aug 26 2003 Laurent Culioli <laurent@pschit.net> 0.67-2mdk
- gaim-encrypt is back ! ( 2.08 )

* Mon Aug 25 2003 Laurent Culioli <laurent@pschit.net> 0.67-1mdk
- 0.67
- drop preference segfault patch
- drop encrypt patch ( gaim-encrypt is now a separate package )

* Sun Aug 10 2003 Laurent Culioli <laurent@pschit.net> 0.66-2mdk
  -Abel Cheung <maddog@linux.org.hk> 
    o Patch3: Encrypt plugin was not linking with libnss3

* Wed Aug  6 2003 Austin Acton <aacton@yorku.ca> 0.66-1mdk
- from Abel Cheung <maddog@linux.org.hk> :
  - 0.66, rebuilt against perl 5.8.1
  - encryption patch 2.02
  - Revert encryption patch to vanilla source form, so patches
    can be more easily inspected
  - Patch2: patch that comes from encryption support against gaim,
    modified to detect nss/nspr headers properly
  - Patch1: avoid segfault when converting preference to new style one
  - enable nas support
  - BuildRequires
  - Split gaim-remote libraries/devel files as sub-package

* Tue Jul 29 2003 Pixel <pixel@mandrakesoft.com> 0.64-3mdk
- when requiring the perl-base used for building, include the epoch

* Thu Jul 17 2003 David BAUDENS <baudens@mandrakesoft.com> 0.64-2mdk
- Rebuild

* Mon Jun 16 2003 Nicolas Planel <nplanel@mandrakesoft.com> 0.64-1mdk
- 0.64.
- remove autoadd hack.
- encrypt 1.20.

* Wed May 07 2003 Lenny Cartier <lenny@mandrakesoft.com> 0.62-2mdk
- remove disable-screensaver ( David Walser )
- change the buttons behavior in gaim-encrypt patch ( David Walser )

* Fri May 02 2003 Lenny Cartier <lenny@mandrakesoft.com> 0.62-1mdk
- from Raymond Rubicam <raymond_rubicam@redlands.edu> : 
	- Updated to gaim 0.62 source.

* Sun Apr 22 2003 Laurent Culioli <laurent@pschit.net> 0.61-2mdk
- Buildrequires

* Mon Apr 14 2003 Nicolas Planel <nplanel@mandrakesoft.com> 0.61-1mdk
- 0.61.
- fix smiley patch. (#3737)

* Mon Apr 07 2003 Nicolas Planel <nplanel@mandrakesoft.com> 0.60-3mdk
- re-include old patch (smiley,autoadd,encrypt).
- update gaim-encrypt to 1.17.

* Sun Apr 06 2003 Laurent Culioli <laurent@pschit.net> 0.60-2mdk
- Obsoletes hackgaim <= 0.60

* Sun Apr 06 2003 Laurent Culioli <laurent@pschit.net> 0.60-1mdk
- 0.60
- merge with David Walluck specfile 
- clean specfile
- drop gaim-applet subpackage

* Wed Apr 02 2003 Nicolas Planel <nplanel@mandrakesoft.com> 0.59.9-1mdk
- update to 0.59.9.
- Add encrypt plugin support. (http://gaim-encryption.sourceforge.net)

* Mon Jan 20 2003 Nicolas Planel <nplanel@mandrakesoft.com> 0.59.8-2mdk
- fix autoadd plugin (segfault when you send message :( )

* Tue Jan 14 2003 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.59.8-1mdk
- Bump to version 0.59.8 (fix yahoo connection).

* Sun Dec 29 2002 Sylvestre Taburet <staburet@mandrakesoft.com> 0.59.6-1mdk
- update to 0.59.7

* Tue Nov 12 2002 Sylvestre Taburet <staburet@mandrakesoft.com> 0.59.6-1mdk
- update to 0.59.6

* Tue Oct 17 2002 Sylvestre Taburet <staburet@mandrakesoft.com> 0.59.5-1mdk
- update to 0.59.5

* Mon Oct 07 2002 Sylvestre Taburet <staburet@mandrakesoft.com> 0.59.4-1mdk
- update to 0.59.4

* Thu Sep 26 2002 Sylvestre Taburet <staburet@mandrakesoft.com> 0.59.3-1mdk
- update to 0.59.3

* Tue Sep 10 2002 Sylvestre Taburet <staburet@mandrakesoft.com> 0.59.2-1mdk
- update to 0.59.2

* Sat Sep  7 2002 Pixel <pixel@mandrakesoft.com> 0.59.1-2mdk
- rebuild (to have a release greater than 8.2 update)

* Tue Aug 27 2002 Vincent Danen <vdanen@mandrakesoft.com> 0.59.1-1mdk
- 0.59.1 (aka security fix)
- remove P3 (fixed upstream)

* Sun Aug 11 2002 Pixel <pixel@mandrakesoft.com> 0.59-7mdk
- patch to fix segfault with perl thread-multi (by Timothy Lee, thanks to David Walser)

* Fri Aug  9 2002 Pixel <pixel@mandrakesoft.com> 0.59-6mdk
- disable perl extensions (if someone knows better, please help)

* Tue Aug  6 2002 Pixel <pixel@mandrakesoft.com> 0.59-5mdk
- fix build and rebuild for perl thread-multi

* Mon Jul 15 2002 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.59-4mdk
- Rebuild without Arts.
- Enable soundwrapper.

* Wed Jul 10 2002 Pixel <pixel@mandrakesoft.com> 0.59-3mdk
- rebuild for perl 5.8.0

* Sun Jun 30 2002 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.59-2mdk
- Arts is back.

* Fri Jun 28 2002 Yves Duret <yduret@mandrakesoft.com> 0.59-1mdk
- new upstream release 0.59.

* Thu May 23 2002 Yves Duret <yduret@mandrakesoft.com> 0.58-1mdk
- version 0.58
- fix specfile (two changelog ???).
- patch configure.ac to no more -I/usr/local/include
- temporaly disable applet cause build broken (not ported yet to GNOME2) with a condif build %%applet.
- rewrite menu longdescription.
- macros were ceated to be used.
- png icons.
- one buildrequires per line.

* Wed Mar 27 2002 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.54-3mdk
- Group fix for applet.

* Wed Mar 27 2002 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.54-2mdk
- Merge in changes from Bryan (see below).
- Note that the smiley patch was never removed.
- Fixups to the gnome applet filelist.
- New and shiny 0.54.

* Fri Feb  1 2002 Adrien Demarez <ademarez@mandrakesoft.com> 0.51-1mdk
- Updated gaim

* Mon Jan  7 2002 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.50-3mdk
- Add autoadd module.

* Tue Dec 18 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.50-2mdk
- Oops. Really apply the smiley patch.

* Tue Dec 18 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.50-1mdk
- Upped to 0.50.
- Add chmou patch with modifications for smileys.

* Tue Dec  4 2001 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.49-2mdk
- Add licq2gaim script also.

* Fri Nov 30 2001 Sylvestre Taburet <staburet@mandrakesoft.com> 0.49-1mdk
- upped to 0.49

* Wed Nov 28 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.48-2mdk
- Make Chmou happy by replacing an ugly define with a cleaner one (thx chmou).

* Sat Nov 17 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.48-1mdk
- 0.48 hot from the oven.

* Sun Nov 04 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.47-1mdk
- The new and shiny 0.47.

* Sat Oct 20 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.46-1mdk
- Presenting the all-new 0.46.
- Use Epoch to please Lord Rpmlint.

* Mon Oct 01 2001 Stefan van der Eijk <stefan@eijk.nu> 0.44-2mdk
- BuildRequires: perl-devel
- Remove redundant BuildRequires

* Fri Sep 28 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.44-1mdk
- Presenting the newest gaim 0.44.
- Fix file list: There is no such file called PROTOCOL.

* Tue Sep 11 2001 Vincent Saugey <vince@mandrakesoft.com> 0.43-1mdk
- New version

* Sat Aug  4 2001 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.11.0-0.pre14.1mdk
- pre14.

* Sat Aug  4 2001 Pixel <pixel@mandrakesoft.com> 0.11.0-0.pre11.2mdk
- add require the perl-base used for building (the libperl.so
  auto-require is not enough)

* Fri May 18 2001 Geoffrey Lee <snailtalk@mandrakesoft.com> 0.11.0-0.pre11.1mdk
- New and shiny source.
- Fix the release number. This would mean that we would have to add a 
  Serial: for the time being :(, but at least this is more sane than before.
- Gaim homepage has now moved over to SourceForge.

* Thu Apr 12 2001 Vincent Saugey <vince@mandrakesoft.com> 0.11.0pre7-2mdk
- Adding BuildRequires gettext, gtkdevel (Thanks to Don Head)

* Fri Mar 23 2001 Vincent Saugey <vince@mandrakesoft.com> 0.11.0pre7-1mdk
- Up to new version

* Fri Mar 23 2001 Vincent Saugey <vince@mandrakesoft.com> 0.11.0pre4-4mdk
- Change group for make fred (crozat) happy.

* Tue Feb 27 2001 Jeff Garzik <jgarzik@mandrakesoft.com> 0.11.0pre4-3mdk
- Fix build on glibc.
- Do not build useless static libs.
- Use macros for make and configure.
- Run autoconf/make tools in prep stage
- Remove COPYING from docs, require common-licenses

* Tue Feb 13 2001 Vincent Saugey <vince@mandrakesoft.com> 0.11.0pre4-2mdk
- Corrected menu section

* Mon Feb 12 2001 Vincent Saugey <vince@mandrakesoft.com> 0.11.0pre4-1mdk
- Up to new version

* Tue Oct 10 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.10.3-1mdk
- up to 0.10.3

* Tue Sep 26 2000 Daouda Lo <daouda@mandrakesoft.com> 0.9.20-5mdk
- menu title should begin with capital letter.
- ICQ section was replaced by Instant messaging.
 
* Thu Sep  7 2000 Vincent Saugey <vince@mandrakesoft.com> 0.9.20-4mdk
- Adding small and large icons

* Tue Aug 29 2000 Vincent Saugey <vince@mandrakesoft.com> 0.9.20-3mdk
- Change icon for menu

* Mon Aug 07 2000 Frederic Lepied <flepied@mandrakesoft.com> 0.9.20-2mdk
- automatically added BuildRequires

* Mon Jul 17 2000 Vincent Saugey <vince@mandrakesoft.com> 0.9.20-1mdk
- up to 0.9.20

* Fri Jun 23 2000 Vincent Saugey <vince@mandrakesoft.com> 0.9.19-1mdk
- 0.9.19

* Thu Jun  8 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.9.18-1mdk
- 0.9.18
- minor fixes in specfile

* Fri Apr 28 2000 Daouda Lo <daouda@mandrakesoft.com> 0.9.11-3mdk
- add 32*32 icon

* Fri Mar 31 2000 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.9.11-2mdk
- Don't +x the menu entries.

* Fri Mar 31 2000 John Buswell <johnb@mandrakesoft.com> 0.9.11-1mdk
- v0.9.11
- Added menu
- fixed group
- spec-helper

* Wed Nov 03 1999 John Buswell <johnb@mandrakesoft.com>
Build Release

* Tue Nov 02 1999 Lenny Cartier <lenny@mandrakesoft.com>
v0.9.9

* Wed Oct 13 1999 Lenny Cartier <lenny@mandrakesoft.com>
- Specfile adaptations.
