#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<sys/socket.h>
#include<features.h>
#include<linux/if_packet.h>
#include<linux/if_ether.h>
#include<arpa/inet.h>
#include<errno.h>
#include<sys/ioctl.h>
#include<net/if.h>
#include"csum.h"

#define PKT_LENGTH	     512
#define ETH_TYPE_MPLS        0x8847
#define ETH_TYPE_VLAN        0x0800
#define ETH_DST_ADDR_OFF     0
#define ETH_SRC_ADDR_OFF     ETH_DST_ADDR_OFF  + ETH_ALEN
#define ETH_TYPE_ADDR_OFF    ETH_SRC_ADDR_OFF  + ETH_ALEN
#define VLAN_TPID_ADDR_OFF   ETH_TYPE_ADDR_OFF
#define VLAN_VID_ADDR_OFF    VLAN_TPID_ADDR_OFF + 2
#define VLAN_TYPE_ADDR_OFF   VLAN_VID_ADDR_OFF + 2
#define MPLS_HDR_ADDR_OFF    ETH_TYPE_ADDR_OFF + 2
#define IP_HDR_ADDR_OFF      MPLS_HDR_ADDR_OFF + 4

typedef union {
    struct {
         uint8_t   	ttl:8;
	 uint8_t   	s:1;
	 uint8_t   	exp:3;
	 uint32_t	label:20;
	};
    uint32_t value;
} mpls_hdr;

typedef union {
    struct {
         uint16_t   	vid:12;
	 uint8_t   	cfi:1;
	 uint8_t   	pcp:3;
	};
    uint16_t value;
} vlan_hdr;

static int 
create_sock (int proto)
{
    int sock;

    if ((sock = socket(AF_PACKET, SOCK_RAW, htons(proto))) == -1) {
        perror("Error creating socket: ");
        exit(-1);
    }
    return sock;
}

static int 
bind_sock (char *device, int sock, int protocol)
{
	
    struct sockaddr_ll sll;
    struct ifreq ifr;
    bzero(&sll, sizeof(sll));
    bzero(&ifr, sizeof(ifr));
	
    /* First Get the Interface Index  */
    strncpy((char *)ifr.ifr_name, device, IFNAMSIZ);
    if ((ioctl(sock, SIOCGIFINDEX, &ifr)) == -1) {
        printf("Error getting Interface index !\n");
        exit(-1);
    }

    /* Bind socket to this interface */
    sll.sll_family = AF_PACKET;
    sll.sll_ifindex = ifr.ifr_ifindex;
    sll.sll_protocol = htons(protocol); 

    if ((bind(sock, (struct sockaddr *)&sll, sizeof(sll)))== -1) {
        perror("Error binding socket to interface\n");
        exit(-1);
    }

    return 1;
}

static int 
send_pkt (int sock, uint8_t *pkt, int pkt_len)
{
    int sent = 0;

    /* A simple write on the socket ..thats all it takes ! */

    if ((sent = write(sock, pkt, pkt_len)) != pkt_len) {
        return 0;
    }
    return 1;
}

static void 
write_ether_hdr (uint8_t *pkt, uint16_t eth_type)
{
    /*MAC address of the host*/
    uint8_t src_mac[ETH_ALEN] = {0x00, 0x27, 0x13, 0x67, 0xb9, 0x9b};
  
    /*gateway MAC address*/
    uint8_t dest_mac[ETH_ALEN] = {0x00, 0x1f, 0x9e, 0x2a, 0x7f, 0xdd};

    eth_type = htons(eth_type);

    memcpy((void*)(pkt + ETH_DST_ADDR_OFF), (void*)dest_mac, ETH_ALEN);
    memcpy((void*)(pkt + ETH_SRC_ADDR_OFF), (void*)src_mac, ETH_ALEN);
    memcpy((void*)(pkt + ETH_TYPE_ADDR_OFF), (void*)&eth_type, 2);
}

static void 
write_vlan_hdr (uint8_t *pkt, uint32_t vid, uint32_t cfi, uint32_t pcp)
{
    vlan_hdr vlan_h;
    uint16_t tpid = htons(0x8100);

    vlan_h.pcp = pcp;
    vlan_h.cfi = cfi;
    vlan_h.vid = vid;

    printf("vlan_h = %x\n", vlan_h.value);
    printf("vlan_h.pcp = %u\n"
           "vlan_h.cfi = %u\n"
           "vlan_h.vid = %u\n",
            vlan_h.pcp, vlan_h.cfi, vlan_h.vid);

    uint16_t vlan_raw = htons(vlan_h.value);

    memcpy((void*)(pkt + VLAN_TPID_ADDR_OFF), (void *)&tpid, 2); 
    memcpy((void*)(pkt + VLAN_VID_ADDR_OFF), (void *) &vlan_raw, 2);
}

static void 
write_vlan_ether_hdr (uint8_t *pkt, uint16_t eth_type, 
                      uint32_t vid, uint32_t cfi, uint32_t pcp)
{
    /*MAC address of the host*/
    uint8_t src_mac[ETH_ALEN] = {0x00, 0x27, 0x13, 0x67, 0xb9, 0x9b};
  
    /*gateway MAC address*/
    uint8_t dest_mac[ETH_ALEN] = {0x00, 0x1f, 0x9e, 0x2a, 0x7f, 0xdd};

    eth_type = htons(eth_type);

    memcpy((void*)(pkt + ETH_DST_ADDR_OFF), (void*)dest_mac, ETH_ALEN);
    memcpy((void*)(pkt + ETH_SRC_ADDR_OFF), (void*)src_mac, ETH_ALEN);
    
    write_vlan_hdr (pkt, vid, cfi, pcp);

    memcpy((void*)(pkt + VLAN_TYPE_ADDR_OFF), (void*)&eth_type, 2);
}

static void 
write_mpls_hdr (uint8_t *pkt, uint32_t label, 
                uint32_t exp, uint32_t s, uint32_t ttl)
{
    mpls_hdr mpls_h;

    mpls_h.ttl = ttl;
    mpls_h.exp = exp;
    mpls_h.s = s;
    mpls_h.label = label;

    printf("mpls_h = %x\n", mpls_h.value);
    printf("mpls_h.label = %u\n"
           "mpls_h.tc = %u\n"
           "mpls_h.s = %u\n"
           "mpls_h.ttl = %u\n",
            mpls_h.label, mpls_h.exp, mpls_h.s, mpls_h.ttl);

    uint32_t mpls_raw = htonl(mpls_h.value);

    memcpy((void*)(pkt), (void *) &mpls_raw, 4);
}

static void 
write_ip_hdr (uint8_t *pkt, uint16_t ip_pkt_len)
{
     uint8_t ip_hdr[20] = { 0x45, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00,
                            0x40, 0x11, 0xa3, 0xfc,
                            0x0a, 0x75, 0x2e, 0xc8, 
                            0x0a, 0x75, 0x2e, 0xc1};

    ip_hdr[2] = (0xFF00 & ip_pkt_len) >> 8;
    ip_hdr[3] = 0x00FF & ip_pkt_len;

    memcpy((void *)(pkt), (void *) &ip_hdr, 20);
}

static void 
write_udp_hdr (uint8_t *pkt, uint16_t udp_len)
{
    uint8_t udp_hdr[8] = {0x0F, 0x00, 0x0F, 0x00,
                          0x00, 0x00, 0x00, 0x00};

    udp_hdr[4] = (0xFF00 & udp_len) >> 8;
    udp_hdr[5] = (0x00FF & udp_len);

    printf("udp_len = %u   udp_hdr[4]=%02x udp_hdr[5]=%02x\n", 
            udp_len ,udp_hdr[4], udp_hdr[5]);

    memcpy((void *)(pkt), (void *) &udp_hdr, 8);
}

static void 
write_ip_csum (uint8_t *pkt, uint16_t len)
{
    /* len should be just the length of the header */
    uint16_t ip_csum = 0;

    /* initialize the ip checksum field to 0 for 
     * purposes of calculating the header */
    memcpy(pkt + 10, &ip_csum, 2);

    /* appears to return in network byte order somehow */
    ip_csum = csum(pkt, len);
    memcpy(pkt + 10, &ip_csum, 2);
}

/* argv[1] is the device e.g. eth0
   argv[2] is the number of pkts to send
*/
 
main (int argc, char **argv)
{

    uint8_t sock;
    uint8_t pkt[PKT_LENGTH];
    uint8_t *pkt_pos = pkt;
    uint8_t *ip_pos;
    uint32_t label = 10, exp = 3, ttl = 10;
    uint32_t vid = 1, pcp = 0;
    uint32_t num_of_pkts, num_labels; 
    uint16_t i = 0;
    uint8_t *str = "FEEDFACE";

    if (argc != 4) {
        printf("usage: %s <device> <# pkts> <#labels>\n", argv[0]);
        return -1;
    }

    num_of_pkts = atoi(argv[2]);
	
    /* Set the pkt to all A's */
    for (i = 0; i < PKT_LENGTH; i+=8) {
        memcpy((void*)(pkt + i), (void*)str, 8);
    }
	
    num_labels = atoi(argv[argc-1]);

    if (num_labels == 0) {
        write_vlan_ether_hdr(pkt_pos, ETH_TYPE_VLAN, vid, 0, pcp);
        pkt_pos += 18;
    } else {
        write_ether_hdr(pkt_pos, ETH_TYPE_MPLS);
        pkt_pos += MPLS_HDR_ADDR_OFF;
        for (i = 0; i < num_labels; i++) {
            if (i == num_labels - 1) {
                write_mpls_hdr(pkt_pos, label++, exp, 1, ttl++);
            } else {
                write_mpls_hdr(pkt_pos, label++, exp, 0, ttl++);
            }
            pkt_pos += 4;
        }
    }

    ip_pos = pkt_pos;
    write_ip_hdr(pkt_pos, PKT_LENGTH - (ip_pos - pkt));
    pkt_pos += 20;

    write_udp_hdr(pkt_pos, PKT_LENGTH -(pkt_pos - pkt));
    pkt_pos += 8;

    write_ip_csum(ip_pos, 20);

    /* Create the socket */
    sock = create_sock(ETH_P_ALL);

    /* Bind socket to interface */
    bind_sock(argv[1], sock, ETH_P_ALL);

    printf("\nPrinting packet\n");
    for (i = 0; i < 50; i++)
        printf("%x ", pkt[i]);
    printf("\n\n");

    while ((num_of_pkts--) > 0) {

        if (!send_pkt(sock, pkt, PKT_LENGTH)) {
            perror("Error sending pkt");
        } else {
            printf("Packet sent successfully\n");
        }
    }

    close(sock);

    return 0;
}

