package tests;

import math.Mean;
import junit.framework.TestCase;

public class MeanTest extends TestCase{

	public void testAccumulatedMean(){
		Mean mean = new Mean();
		assertEquals(1d, mean.calculate(1d));
		assertEquals(2.5, mean.calculate(4d));
	}
	
	public void testRollingMean(){
		Mean mean = new Mean(3);
		assertEquals(Double.NaN, mean.calculate(4d));
		assertEquals(Double.NaN, mean.calculate(5d));
		assertEquals(3.33333d, mean.calculate(1d), 1E-5);
		assertEquals(3d, mean.calculate(3d));
	}
}
