#
# Makefile which sets common variables for all sub-parts of the TI s/w
#

CUST	= 0

# ANALOG
ANALOG  = 1# 0 means Vega - 1 means Omega
ANALOG0	:=_ve
ANALOG1	:=_om
NANALOG	:=$(ANALOG$(ANALOG))

# FLASH
FLASH   = 50# Default value is no flash
FLASH0	:=_int1
FLASH1	:=_int2
FLASH2	:=_int3
FLASH16 :=_sha1
FLASH17	:=_sha2
FLASH18	:=_sha3
FLASH32	:=_amd1#AMD AM29DL800BB
FLASH33	:=_amd2#AMD AM29LV160BB
FLASH48	:=_fuj1
FLASH49	:=_fuj2
FLASH50 :=_fuj4
FLASH99	:=#no flash
NFLASH	:=$(FLASH$(FLASH))

# VOICE MEMO
MEMO   = 0# 0 = no - 1 = yes
MEMO0	:=# no voice memo
MEMO1	:=_vm
NMEMO	:=$(MEMO$(MEMO))

# DWNLD
ifeq ($(CHIPSET),3)
  	DWNLD = 1# patch download
else
	DWNLD = 3#code and patch download
endif

DWNLD0	:=
DWNLD1	:=_pa
DWNLD2	:=_ds
DWNLD3	:=_pd
NDWNLD	:=$(DWNLD$(DWNLD))

OBJ 	= $(TI_DIR)/obj

#
# TI libraries
# 

L1_STD_LIB  = $(TI_LIB)/l1$(NPMODE)$(NSRVC)$(NBRD)$(NCHP)$(NDSP)$(NDWNLD).lib
L1_CST_LIB  = $(TI_LIB)/l1_custom$(NPMODE)$(NSRVC)$(NANALOG)$(NRF)$(NDSP)$(NDWNLD).lib

TPU_LIB = $(TI_LIB)/tpu$(NPMODE)$(NANALOG)$(NRF).lib

BOARD_LIB   = $(TI_LIB)/board$(NBRD)$(NCHP).lib

#For ffs , name differenciation is not required because it is always rebuilt
PCM_LIB     = $(TI_LIB)/ffs.lib


RTS_LIB     = $(TI_LIB)/rts16le.lib
BOOTLOADER_LIB = $(TI_LIB)/bootloader$(NBRD).lib
DRVFLASH_LIB = $(TI_LIB)/drvflash.lib

TI_LIBS = $(PCM_LIB) $(L1_STD_LIB) $(L1_CST_LIB) $(BOARD_LIB) $(TPU_LIB) $(RTS_LIB) $(DRVFLASH_LIB) $(BOOTLOADER_LIB)


#
#   Paths for the include files
#

IL1     = $(TI_DIR)/l1$(NPMODE)/l1_std/include
IL2     = $(TI_DIR)/l1$(NPMODE)/l1_cst
ifeq ($(CHIPSET),0) 		#Gemini/Polestar
   IL3     = $(TI_DIR)/l1$(NPMODE)/tpu_drivers/source
else						#Hercules/Ulysse
   IL3     = $(TI_DIR)/l1$(NPMODE)/tpu/tpu_drivers1/source
endif

SRC     = $(TI_DIR)/l1$(NPMODE)/l1_std/dl1
IPCM    = $(TI_DIR)/ffs
INCHIN  = $(TI_DIR)/l1$(NPMODE)/l1_std/hint
SRCL1   = $(CONDAT_DIR)/ms/src/l1


INCCONDAT     = $(CONDAT_DIR)/com/include
INCBTCOMMON   = $(BT_DIR)/Common/BTF
INCBTGENERAL  = $(BT_DIR)/Common/General
DRVBOARD      = $(TI_DIR)/drv/board_$(BOARD)
DRVCOMMON     = $(TI_DIR)/drv/common

INCDRV = -i$(DRVBOARD) -i$(DRVCOMMON) -i$(INCCONDAT) -i$(IL1) -i$(IL2) -i$(SRCL1) -i$(BT_GENERAL) -i$(BT_BOARD)/drv
HACK_INC = -i$(INCBTCOMMON) -i$(INCBTGENERAL) -i$(INCCONDAT)

#
#   Build options
#

# Workaround Flag to be used in advance in this non officialy corrected 
# version
# Workaround Validation (1: code enabled; 0: code disabled)
# ---------------------------------------------------------


CDEFS_TI    =  -DANALOG=$(ANALOG) -DDWNLD=$(DWNLD) $(CDEFS_ENV) -DFLASH=$(FLASH)

CFLAGS32 = -me -o -pw2 -mw -fr$(OBJ)
CFLAGS16 = -mt $(CFLAGS32) 

L1FLAGS32 = -me -o -pw2 -mw -fr$(OBJ)
L1FLAGS32_NO_OPT = -me -pw2 -mw -fr$(OBJ)
L1FLAGS32_NO_OPT_WA = -me -pw2 -fr$(OBJ)

L1FLAGS16 = -mt $(L1FLAGS32)
L1FLAGS16_NO_OPT = -mt $(L1FLAGS32_NO_OPT)
L1FLAGS16_NO_OPT_WA = -mt $(L1FLAGS32_NO_OPT_WA)








