#
# TI directory sub-makefile
#
#
export

ti: FORCE obj_dir
	-$(MAKE) -C l1$(NPMODE)/l1_std -f l1_std.mak
	-$(MAKE) -C l1$(NPMODE)/l1_cst -f l1_cst.mak
	-$(MAKE) -C l1$(NPMODE)/tpu -f tpu.mak
	-$(MAKE) -C drv -f board.mak
	-$(MAKE) -C ffs -f ffs.mak
	-$(MAKE) -C bootloader -f bootloader.mak
ifdef SW_HWTEST # Build of HW Test
	-$(MAKE) -C test -f test.mak
test: FORCE
	-$(MAKE) -C test -f test.mak
endif
l1_std: FORCE
	-$(MAKE) -C l1$(NPMODE)/l1_std -f l1_std.mak
	-$(MAKE) -C ffs -f ffs.mak
l1_cst: FORCE
	-$(MAKE) -C ll1$(NPMODE)/1_cst -f l1_cst.mak
	-$(MAKE) -C ffs -f ffs.mak
tpu: FORCE
	-$(MAKE) -C l1$(NPMODE)\tpu -f tpu.mak
	-$(MAKE) -C ffs -f ffs.mak
board: FORCE
	-$(MAKE) -C drv -f board.mak
	-$(MAKE) -C ffs -f ffs.mak

ffs: FORCE
	-$(MAKE) -C ffs -f ffs.mak
bootloader: FORCE
	-$(MAKE) -C bootloader -f bootloader.mak

obj_dir:
	-mkdir $(subst /,$(SLASH),$(OBJ))

clean:
	-$(MAKE) -C l1$(NPMODE)/l1_std -f l1_std.mak clean
	-$(MAKE) -C l1$(NPMODE)/l1_cst -f l1_cst.mak clean
	-$(MAKE) -C l1$(NPMODE)/tpu -f tpu.mak clean
	-$(MAKE) -C drv -f board.mak clean
	-$(MAKE) -C ffs -f ffs.mak clean
	-$(MAKE) -C bootloader -f bootloader.mak clean
ifdef SW_HWTEST # Build of HW Test
	-$(MAKE) -C test -f test.mak clean
endif
FORCE:
