#
# HW test makefile
#
# Build HW test library
#
#




COPF     = $(DBG)-mn -x -g $(CFLAGS16)  

COP32    = -x $(CFLAGS32) 

THE_LIB = ../../$(TST_LIB)



TST_OBJ   = $(OBJ)/message.obj $(OBJ)/mmi.obj \
            $(OBJ)/testlcd.obj $(OBJ)/testlead.obj $(OBJ)/testpcm.obj \
            $(OBJ)/testtpu.obj $(OBJ)/testuart.obj $(OBJ)/testomega.obj\
            $(OBJ)/system.obj  $(OBJ)/testgen.obj $(OBJ)/testkeys.obj \
            $(OBJ)/testsim.obj $(OBJ)/testrf.obj $(OBJ)/hwtest.obj
#
# Targets
#

all: $(THE_LIB)

clean:
	-$(REMOVE) $(subst /,$(SLASH),$(TST_OBJ))
	-$(REMOVE) $(subst /,$(SLASH),$(THE_LIB))

#
# Build library
#

$(THE_LIB): $(TST_OBJ)
	ar470 r $(THE_LIB) $(TST_OBJ) 

#
# Build objects
#

$(OBJ)/message.obj: message.c message.h $(IN1)/nucleus.h 
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -I$(IN1) $(INCDRV) message.c	 

$(OBJ)/mmi.obj: mmi.c mmi.h $(IN1)/nucleus.h $(DRVCOMMON)/buzzer.h \
                $(DRVCOMMON)/iq.h $(DRVBOARD)/lcd.h message.h \
                testgen.h testkeys.h \
                testlcd.h testlead.h \
                testrf.h testsim.h testtpu.h \
                testuart.h testpcm.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IN1) $(INCDRV) mmi.c

$(OBJ)/hwtest.obj: hwtest.c $(DRVCOMMON)/buzzer.h $(DRVCOMMON)/armio.h \
                    $(DRVCOMMON)/iq.h $(DRVBOARD)/keypad.h \
                    $(DRVBOARD)/lcd.h $(IL1)/l1_heade.h message.h \
                    mmi.h $(IN1)/nucleus.h \
                    system.h testkeys.h testomega.h \
                    testsim.h testuart.h \
                    $(DRVCOMMON)/uart.h

	     cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -I$(IL1) -i$(IPCM) -i$(IL3) -i$(INCHIN) \
	                   -i$(IN1) -i$(MBINC) $(INCDRV) hwtest.c
	                                          
$(OBJ)/testgen.obj: testgen.c testgen.h $(DRVCOMMON)/buzzer.h \
                    message.h $(IN1)/nucleus.h $(DRVCOMMON)/iq.h

	cl470  $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IN1) -i$(IL1) $(INCDRV) \
          testgen.c

$(OBJ)/testkeys.obj: testkeys.c testkeys.h \
                     $(DRVBOARD)/keypad.h $(IL1)/l1_heade.h \
                     message.h $(IN1)/nucleus.h \
                     system.h $(DRVCOMMON)/uart.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IN1) -i$(IL3) -i$(INCHIN) \
          -i$(INCCUS) $(INCDRV) testkeys.c

$(OBJ)/testlcd.obj: testlcd.c testlcd.h $(DRVBOARD)/lcd.h \
                    message.h
	cl470 $(COPF) $(CDEFS_TI) -i$(IL1) $(INCDRV) testlcd.c

$(OBJ)/testlead.obj: testlead.c testlead.h \
                     $(DRVCOMMON)/leadapi.h message.h $(IN1)/nucleus.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IN1) \
          $(INCDRV) testlead.c

$(OBJ)/testrf.obj: testrf.c testrf.h $(IL1)/l1_heade.h \
                   message.h system.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IL3) -i$(IN1) -i$(INCHIN) \
          $(INCDRV) testrf.c

$(OBJ)/testsim.obj: testsim.c testsim.h message.h \
                    $(DRVCOMMON)/sim.h

	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -I$(IN1) $(INCDRV) \
          testsim.c

$(OBJ)/testtpu.obj: testtpu.c testtpu.h $(DRVCOMMON)/iq.h \
                    message.h $(IN1)/nucleus.h \
                    $(IL3)/tpudrv.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL3) -i$(IN1) -i$(IL1)\
          $(INCDRV) testtpu.c

$(OBJ)/testuart.obj: testuart.c testuart.h message.h \
                     $(IN1)/nucleus.h $(DRVCOMMON)/uart.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IN1) $(INCDRV)\
         testuart.c

$(OBJ)/testomega.obj: testomega.c testomega.h message.h \
                      $(DRVCOMMON)/spi.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IN1) $(INCDRV)\
         testomega.c

$(OBJ)/testpcm.obj: $(IN1)/nucleus.h testpcm.c testpcm.h $(IPCM)/pcm.h \
                    message.h 
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IPCM) -i$(IN1) $(INCDRV) testpcm.c

$(OBJ)/system.obj: system.c system.h $(IL1)/l1_heade.h $(IN1)/nucleus.h
	cl470 $(COPF) $(CDEFS_TI) -DL1_LIB=1 -i$(IL1) -i$(IL3) -i$(INCCUS) -i$(INCHIN)  \
          -i$(IN1) $(INCDRV) system.c


