#
# Makefile used to build the Layer1 standard library 
#
#

L1DBG       = -g         #  -g to compile with debug option

CDEFS_L1 = $(CDEFS_TI) $(L1DBG)

CCODE		= 	cfile
PCCODE		= 	p_cfile
MACCODE		= 	cmacs


ifeq ($(CHIPSET),0) 		#Gemini/Polestar
	L1D 	= 	dsp
else						#Hercules/Ulysse
	L1D 	= 	dsp1
endif

INC_INT		= 	hint
INC_P		= 	p_include
INC_PMACS	= 	hmacs

L1INC   	= 	$(IL1)/l1_heade.h $(IL1)/l1_const.h $(IL1)/l1_defty.h \
		  		$(IL1)/l1_macro.h $(IL1)/l1_mftab.h $(IL1)/l1_msgty.h \
		  		$(IL1)/l1_proto.h $(IL1)/l1_signa.h $(IL1)/l1_time.h 

PINC1 		=	$(INC_P)/l1p_cons.h $(INC_P)/l1p_deft.h $(INC_P)/l1p_macr.h \
      			$(INC_P)/l1p_mfta.h $(INC_P)/l1p_msgt.h $(INC_P)/l1p_prot.h \
      			$(INC_P)/l1p_sign.h $(INC_P)/l1p_tabs.h $(INC_P)/l1p_type.h \
      			$(INC_P)/l1p_vare.h $(INC_P)/l1p_ver.h

PINCMACS	= 	$(INC_PMACS)/macs_def.h $(INC_PMACS)/macs_cst.h $(INC_PMACS)/macs_var.h

ifneq ($(DSP),30)
L1_GSM_OBJ 	= 	$(OBJ)/l1_ctl.obj $(OBJ)/l1_sync.obj $(OBJ)/l1_func.obj \
		  		$(OBJ)/l1_async.obj $(OBJ)/l1_drive.obj $(OBJ)/l1_cmplx.obj \
		  		$(OBJ)/l1_afunc.obj $(OBJ)/l1_mfmgr.obj $(OBJ)/leadboot.obj \
		  		$(OBJ)/l1_extmem.obj $(OBJ)/l1_pwmgr.obj $(OBJ)/l1_init.obj \
		  		$(OBJ)/DspCode_file$(DSP).obj $(OBJ)/DspData_file$(DSP).obj \
				$(OBJ)/patch_file$(DSP).obj \
		  		$(OBJ)/dl1_com.obj $(OBJ)/l1_audio.obj $(OBJ)/l1_trace.obj \
                $(OBJ)/l1_voice.obj $(OBJ)/l1_small.obj \
				
L1_TESTMODE_OBJ = $(OBJ)/l1_tmode.obj $(OBJ)/l1_tmstat.obj \

else
L1_GSM_OBJ 	= 	$(OBJ)/l1_ctl.obj $(OBJ)/l1_sync.obj $(OBJ)/l1_func.obj \
		  		$(OBJ)/l1_async.obj $(OBJ)/l1_drive.obj $(OBJ)/l1_cmplx.obj \
		  		$(OBJ)/l1_afunc.obj $(OBJ)/l1_mfmgr.obj $(OBJ)/leadboot.obj \
		  		$(OBJ)/l1_extmem.obj $(OBJ)/l1_pwmgr.obj $(OBJ)/l1_init.obj \
		  		$(OBJ)/DspCode_file$(DSP).obj $(OBJ)/DspData_file$(DSP).obj \
		  		$(OBJ)/dl1_com.obj $(OBJ)/l1_audio.obj $(OBJ)/l1_trace.obj \
                $(OBJ)/l1_voice.obj $(OBJ)/l1_small.obj \
				
                
endif

L1_GPRS_OBJ = 	$(OBJ)/l1p_afun.obj $(OBJ)/l1p_asyn.obj $(OBJ)/l1p_cmpl.obj \
				$(OBJ)/l1p_driv.obj $(OBJ)/l1p_func.obj $(OBJ)/l1p_sync.obj \
				$(OBJ)/macs.obj

ifeq ($(GPRS),0) 				# not GPRS
	L1_ALL_OBJ = $(L1_GSM_OBJ) $(L1_TESTMODE_OBJ)
else							# GPRS
	L1_ALL_OBJ = $(L1_GSM_OBJ) $(L1_GPRS_OBJ)
endif

#
#	Layer1 standard library build
#
THE_LIB = ../../../$(L1_STD_LIB)

all: $(THE_LIB)   

$(THE_LIB): $(L1_ALL_OBJ)
	-$(REMOVE) $(subst /,$(SLASH),$(THE_LIB))
	ar470 r $(THE_LIB) $(L1_ALL_OBJ)

clean:
	-$(REMOVE) $(subst /,$(SLASH),$(L1_ALL_OBJ))
	-$(REMOVE) $(subst /,$(SLASH),$(THE_LIB))

#
# GSM source files
#

$(OBJ)/l1_extmem.obj: $(CCODE)/l1_extmem.c $(L1INC)
		cl470 $(L1FLAGS16_NO_OPT_WA) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_extmem.c

$(OBJ)/l1_ctl.obj: $(CCODE)/l1_ctl.c $(L1INC)
		cl470 -x $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_ctl.c

$(OBJ)/l1_sync.obj: $(CCODE)/l1_sync.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_sync.c

$(OBJ)/l1_func.obj: $(CCODE)/l1_func.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_func.c

$(OBJ)/l1_async.obj: $(CCODE)/l1_async.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_async.c

$(OBJ)/l1_drive.obj: $(CCODE)/l1_drive.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_drive.c

$(OBJ)/l1_cmplx.obj: $(CCODE)/l1_cmplx.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_cmplx.c

$(OBJ)/l1_afunc.obj: $(CCODE)/l1_afunc.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_afunc.c

$(OBJ)/l1_mfmgr.obj: $(CCODE)/l1_mfmgr.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_mfmgr.c

$(OBJ)/l1_pwmgr.obj: $(CCODE)/l1_pwmgr.c $(L1INC)
		cl470 $(L1FLAGS16_NO_OPT) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(CCODE)/l1_pwmgr.c

$(OBJ)/l1_small.obj: $(CCODE)/l1_small.c $(L1INC)
		cl470 $(DBG) $(L1FLAGS32_NO_OPT) -fr$(OBJ) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3)\
		 		-I$(INC_P) -I$(INC_INT) -I$(IN1) -i$(ICOM) $(INCDRV) $(CCODE)/l1_small.c

$(OBJ)/l1_audio.obj: $(CCODE)/l1_audio.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -i$(ICOM) $(INCDRV) $(CCODE)/l1_audio.c

$(OBJ)/l1_voice.obj: $(CCODE)/l1_voice.c $(L1INC)
		cl470 $(L1FLAGS16_NO_OPT) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -i$(ICOM) $(INCDRV) $(CCODE)/l1_voice.c

$(OBJ)/l1_trace.obj: $(CCODE)/l1_trace.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -i$(ICOM) -i$(BT_GENERAL) -i$(BT_TRACE) $(INCDRV) $(CCODE)/l1_trace.c

$(OBJ)/l1_init.obj: $(CCODE)/l1_init.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -Iti/ffs -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -i$(ICOM) $(INCDRV) $(CCODE)/l1_init.c

$(OBJ)/l1_tmode.obj: $(CCODE)/l1_tmode.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -i$(ICOM) -i$(BT_GENERAL) -i$(BT_TRACE) $(INCDRV) $(CCODE)/l1_tmode.c

$(OBJ)/l1_tmstat.obj: $(CCODE)/l1_tmstat.c $(L1INC)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
     	      -I$(INC_P) -I$(IN1) -i$(ICOM) $(INCDRV) $(CCODE)/l1_tmstat.c

$(OBJ)/DspCode_file$(DSP).obj: $(L1D)/DspCode_file$(DSP).c 
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(ICOM) \
		      $(L1D)/DspCode_file$(DSP).c

$(OBJ)/DspData_file$(DSP).obj: $(L1D)/DspData_file$(DSP).c 
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(ICOM) \
		      $(L1D)/DspData_file$(DSP).c

$(OBJ)/patch_file$(DSP).obj: $(L1D)/patch_file$(DSP).c 
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(ICOM) $(L1D)/patch_file$(DSP).c

$(OBJ)/leadboot.obj: $(L1D)/leadboot.c 
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) $(L1D)/leadboot.c

$(OBJ)/dl1_com.obj: $(SRC)/dl1_com.c $(L1INC)
		cl470 -D$(NCONFIG) -D$(NTRACE) -D$(NWARN) -D$(NUC_DBG) -D$(TIM_MON) \
		        $(L1FLAGS16) $(CDEFS_L1)  -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3)\
		        -I$(INC_INT) -I$(IN1) -i$(ICOM) \
		        -i$(SRC) $(INCDRV) $(SRC)/dl1_com.c
#
#	GPRS source files
#

$(OBJ)/l1p_afun.obj: $(PCCODE)/l1p_afun.c $(L1INC) $(PINC1)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(PCCODE)/l1p_afun.c

$(OBJ)/l1p_asyn.obj: $(PCCODE)/l1p_asyn.c $(L1INC) $(PINC1)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(PCCODE)/l1p_asyn.c

$(OBJ)/l1p_cmpl.obj: $(PCCODE)/l1p_cmpl.c $(L1INC) $(PINC1)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(PCCODE)/l1p_cmpl.c

$(OBJ)/l1p_driv.obj: $(PCCODE)/l1p_driv.c $(L1INC) $(PINC1)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(PCCODE)/l1p_driv.c

$(OBJ)/l1p_func.obj: $(PCCODE)/l1p_func.c $(L1INC) $(PINC1)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(PCCODE)/l1p_func.c

$(OBJ)/macs.obj: $(MACCODE)/macs.c $(INC1) $(PINC1) $(PINCMACS)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) -I$(INC_PMACS) $(MACCODE)/macs.c

$(OBJ)/l1p_sync.obj: $(PCCODE)/l1p_sync.c $(INC1) $(PINC1)
		cl470 $(L1FLAGS16) $(CDEFS_L1) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(INC_INT) \
		      -I$(INC_P) -I$(IN1) -I$(ICOM) $(INCDRV) $(PCCODE)/l1p_sync.c
