#
# Makefile which sets common variables for l1 sub-parts of the TI s/w
#


#NPMODE=_al
#NSRVC = _vo
#NBRD  = _bs
#NCHP  = _ul
#NDSP  = _17
#NDWNLD = _pa
#NANALOG=_om
#NRF = _pa00
#BOARD = 7
#DSP   = 17
#GPRS  = 0
#MMI =1
#SRVC = 0
STD = 6
TESTMODE=3
##RF=8
#CHIPSET=3

#TI_DIR = $(CURDIR)/../..
TI_LIB = ti/lib
OBJ 	= $(TI_DIR)/obj

#
# TI libraries
# 

L1_STD_LIB  = $(TI_LIB)/l1$(NPMODE)$(NSRVC)$(NBRD)$(NCHP)$(NDSP)$(NDWNLD).lib
L1_CST_LIB  = $(TI_LIB)/l1_custom$(NPMODE)$(NSRVC)$(NANALOG)$(NRF)$(NDSP)$(NDWNLD).lib

TI_LIBS = $(L1_STD_LIB) $(L1_CST_LIB)
#export TI_LIBS


#
#   Paths for the include files
#

IL1     = $(TI_DIR)/l1$(NPMODE)/l1_std/include
IL2     = $(TI_DIR)/l1$(NPMODE)/l1_cst
ifeq ($(CHIPSET),0) 		#Gemini/Polestar
   IL3     = $(TI_DIR)/l1$(NPMODE)/tpu_drivers/source
else						#Hercules/Ulysse
   IL3     = $(TI_DIR)/l1$(NPMODE)/tpu/tpu_drivers1/source
endif

SRC     = $(TI_DIR)/l1$(NPMODE)/l1_std/dl1
IPCM    = $(TI_DIR)/pcm
INCHIN  = $(TI_DIR)/l1$(NPMODE)/l1_std/hint
SRCL1   = $(CONDAT_DIR)/ms/src/l1

DRVBOARD      = $(TI_DIR)/drv/board_$(BOARD)
DRVCOMMON     = $(TI_DIR)/drv/common

INCDRV = -i$(DRVBOARD) -i$(DRVCOMMON) -i$(IL1) -i$(SRCL1)

#
#   Build options
#

# Workaround Flag to be used in advance in this non officialy corrected 
# version
# Workaround Validation (1: code enabled; 0: code disabled)
# ---------------------------------------------------------

W_A_PB512_TI_128 = 1
W_A_PB512_TI_132 = 1
W_A_PB512_TI_136 = 1
W_A_PB512_TI_143 = 1

L1_WA = -DW_A_PB512_TI_128=$(W_A_PB512_TI_128)  -DW_A_PB512_TI_132=$(W_A_PB512_TI_132) \
        -DW_A_PB512_TI_136=$(W_A_PB512_TI_136)  -DW_A_PB512_TI_143=$(W_A_PB512_TI_143)

CDEFS_ENV   = -DGPRS=$(GPRS) -DCHIPSET=$(CHIPSET) -DDSP=$(DSP) -DBOARD=$(BOARD)\
				-DRF=$(RF) -DSTD=$(STD) -DTESTMODE=$(TESTMODE) -DSRVC=$(SRVC) -DMMI=$(MMI) 

CDEFS_TI    =  -DANALOG=$(ANALOG) -DDWNLD=$(DWNLD) $(CDEFS_ENV) -DFLASH=$(FLASH)

L1FLAGS32 = -me -o -pw2 -mw -fr$(OBJ) $(L1_WA)
L1FLAGS32_NO_OPT = -me -pw2 -mw -fr$(OBJ) $(L1_WA)
L1FLAGS32_NO_OPT_WA = -me -pw2 -fr$(OBJ) $(L1_WA)

L1FLAGS16 = -mt $(L1FLAGS32)
L1FLAGS16_NO_OPT = -mt $(L1FLAGS32_NO_OPT)
L1FLAGS16_NO_OPT_WA = -mt $(L1FLAGS32_NO_OPT_WA)

