#
# Makefile used to build the Layer1 customizable library 
#
#

L1INC   = $(IL1)/l1_heade.h $(IL1)/l1_const.h $(IL1)/l1_defty.h \
		  $(IL1)/l1_macro.h $(IL1)/l1_mftab.h $(IL1)/l1_msgty.h \
		  $(IL1)/l1_proto.h $(IL1)/l1_signa.h $(IL1)/l1_time.h \
		  $(IL1)/l1_confg.h

L1DBG = -g         # L1 debug option or not

L1_CST_OBJ   = $(OBJ)/l1_cust.obj $(OBJ)/cust_melo.obj \
			   $(OBJ)/ind_os.obj

THE_LIB = ../../../$(L1_CST_LIB)

all: $(THE_LIB)   

$(THE_LIB): $(L1_CST_OBJ)
	-$(REMOVE) $(subst /,$(SLASH),$(THE_LIB))
	ar470 r $(THE_LIB) $(L1_CST_OBJ)

clean:
	-$(REMOVE) $(subst /,$(SLASH),$(L1_CST_OBJ))
	-$(REMOVE) $(subst /,$(SLASH),$(THE_LIB))

#
# Sources files
#

$(OBJ)/l1_cust.obj: l1_cust.c $(L1INC)
		cl470 $(L1FLAGS16) $(L1DBG) $(CDEFS_TI) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(IL4) \
		      -I$(IN1) -i$(ICOM) $(INCDRV) l1_cust.c                


$(OBJ)/ind_os.obj: ind_os.c $(L1INC)
		cl470 $(L1FLAGS16) $(L1DBG) $(CDEFS_TI) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(IL4) \
		      -I$(IN1) -i$(ICOM) -i$(INCHIN) $(INCDRV) ind_os.c                


$(OBJ)/cust_melo.obj: cust_melo.c $(L1INC)
		cl470 $(L1FLAGS16) $(L1DBG) $(CDEFS_TI) -DL1_LIB=1 -I$(IL1) -I$(IL2) -I$(IL3) -I$(IL4) \
		      -I$(IN1) -i$(ICOM) -i$(INCHIN) $(INCDRV) cust_melo.c                


