CFLAGSFLASH :=         -mn -x -mt -o    $(CFLAGS)
CFLAGSBRD   := $(CDBG) -mn -x -mt -o    $(CFLAGS)
CFLAGS32    := $(CDBG)     -x     -o    $(CFLAGS)

LIB_BRD       := ti/lib/board$(NBRD)$(NCHP).lib 
CFG_LIBS      += $(LIB_BRD)

LIB_BRD_FLASH := ti/lib/drvflash.lib 
CFG_LIBS      += $(LIB_BRD_FLASH)

SRC_BRD += ti/drv/board_7/keypad.c 
#ti/drv/board_7/lcd.c
#SRC_BRD and SRC_BRD_FLASH : This is to distinguish the flash lib from the board.lib
SRC_BRD_FLASH  += ti/drv/board_7/drvflash.c ti/drv/board_7/flash.c
ASM_BRD_FLASH  += ti/drv/board_7/flash_s.s
SRC_BRD += ti/drv/common/armio.c   ti/drv/common/buzzer.c    \
           ti/drv/common/init.c         ti/drv/common/inth.c \
           ti/drv/common/leadapi.c ti/drv/common/niq.c       ti/drv/common/niq32.c\
           ti/drv/common/pwr_cst.c   \
           ti/drv/common/serialswitch.c  ti/drv/common/sim.c\
           ti/drv/common/sim32.c         ti/drv/common/timer.c \
           ti/drv/common/timer1.c  ti/drv/common/timer2.c    ti/drv/common/uart.c \
           ti/drv/common/uartfax.c ti/drv/common/clkm.c 
#NOT USED : ti/drv/common/rtc.c ti/drv/common/rhea_arm.c ti/drv/common/spi.c
ASM_BRD += ti/drv/common/int.s

OBJ_ASM_BRD         := $(patsubst %.s,%.obj,$(filter %.s,$(ASM_BRD)))
CFG_OBJS += $(OBJ_ASM_BRD)

OBJ_ASM_BRD_FLASH   := $(patsubst %.s,%.obj,$(filter %.s,$(ASM_BRD_FLASH)))
CFG_OBJS += $(OBJ_ASM_BRD_FLASH)

OBJ_BRD       := $(patsubst %.c,%.obj,$(filter %.c,$(SRC_BRD)))
CFG_OBJS += $(OBJ_BRD)
CFG_DEPS += $(OBJ_BRD:.obj=.d)

OBJ_BRD_FLASH := $(patsubst %.c,%.obj,$(filter %.c,$(SRC_BRD_FLASH)))
CFG_OBJS += $(OBJ_BRD_FLASH)
CFG_DEPS += $(OBJ_BRD_FLASH:.obj=.d)

#Sources that needs to be compiled into 32 bit state code  
#They still must be added to the SRC_BRD due to generation of libraries
SRC32   += ti/drv/common/sim32.c ti/drv/common/niq32.c
OBJ32   := $(patsubst %.c,%.obj,$(filter %.c,$(SRC32)))

$(LIB_BRD) : $(OBJ_BRD) $(OBJ_ASM_BRD)
	ar470 r $(LIB_BRD) $(OBJ_BRD) $(OBJ_ASM_BRD)

$(LIB_BRD_FLASH) : $(OBJ_ASM_BRD_FLASH) $(OBJ_BRD_FLASH)
	ar470 r $(LIB_BRD_FLASH) $(OBJ_ASM_BRD_FLASH) $(OBJ_BRD_FLASH)


$(OBJ_BRD) : %.obj: %.c
	cl470 $(CFLAGSBRD) -fr$(@D) $<

$(OBJ_BRD_FLASH) : %.obj: %.c
	cl470 $(CFLAGSFLASH)  -fr$(@D) $<

$(OBJ32) : %.obj: %.c
	cl470 $(CFLAGS32) -fr$(@D) $<

$(OBJ_ASM_BRD_FLASH) : %.obj : %.s
	asm470 -me $< $@
