#
# BOARD makefile
#
# Build driver library
#
#

COPF     = -mn -x $(CFLAGS16) 

COPF_NO_OPT = -x -c -mt -me $(DRV_DBG) -fr$(OBJ)

COP32    = -x $(CFLAGS32) 

DRV_DBG = -g   #debug option -g

CDEFS_DRV = $(CDEFS_TI) $(DRV_DBG)

#
#   Library name depends on the selected configuration
#

THE_LIB = ../../$(BOARD_LIB)
THE2_LIB = ../../$(DRVFLASH_LIB)

DRVOBJ   = $(OBJ)/armio.obj $(OBJ)/buzzer.obj \
           $(OBJ)/init.obj $(OBJ)/int.obj $(OBJ)/keypad.obj \
           $(OBJ)/leadapi.obj $(OBJ)/niq.obj $(OBJ)/niq32.obj \
           $(OBJ)/serialswitch.obj $(OBJ)/sim.obj $(OBJ)/sim32.obj \
           $(OBJ)/timer.obj $(OBJ)/uart.obj $(OBJ)/uartfax.obj \
           $(OBJ)/clkm.obj $(OBJ)/inth.obj $(OBJ)/timer1.obj \
           $(OBJ)/timer2.obj $(OBJ)/pwr_cst.obj

DRVFLASHOBJ = $(OBJ)/drvflash.obj $(OBJ)/flash.obj $(OBJ)/flash_s.obj

#
# Targets
#

all: $(THE_LIB) $(THE2_LIB)

clean:
	-$(REMOVE) $(subst /,$(SLASH),$(THE_LIB))
	-$(REMOVE) $(subst /,$(SLASH),$(DRVOBJ))
	-$(REMOVE) $(subst /,$(SLASH),$(THE2_LIB))
	-$(REMOVE) $(subst /,$(SLASH),$(DRVFLASHOBJ))

#
# Board support libraries
#

$(THE_LIB): $(DRVOBJ)
	ar470 r $(THE_LIB) $(DRVOBJ) 

$(THE2_LIB): $(DRVFLASHOBJ)
	ar470 r $(THE2_LIB) $(DRVFLASHOBJ) 

#
# Build objects
#

$(OBJ)/drvflash.obj: $(DRVBOARD)/drvflash.c
		cl470 $(COPF) $(CDEFS_TI) $(INCDRV) $(DRVBOARD)/drvflash.c

$(OBJ)/flash.obj: $(DRVBOARD)/flash.c
		cl470 $(COPF) $(CDEFS_TI) $(INCDRV) $(DRVBOARD)/flash.c

$(OBJ)/int.obj: $(DRVCOMMON)/int.s
		asm470 -me -DBOARD=$(BOARD) -D$(TIM_PROF) $(INCDRV) $(DRVCOMMON)/int.s $(OBJ)/int.obj

$(OBJ)/buzzer.obj: $(DRVCOMMON)/buzzer.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) $(DRVCOMMON)/buzzer.c

$(OBJ)/keypad.obj: $(DRVBOARD)/keypad.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) -i$(IN1) $(DRVBOARD)/keypad.c

$(OBJ)/leadapi.obj: $(DRVCOMMON)/leadapi.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) $(DRVCOMMON)/leadapi.c

$(OBJ)/niq.obj: $(DRVCOMMON)/niq.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) $(DRVCOMMON)/niq.c

$(OBJ)/niq32.obj: $(DRVCOMMON)/niq32.c 
		cl470 $(COP32) $(CDEFS_DRV) -i$(IL3) $(INCDRV) -i$(IN1) \
		      $(DRVCOMMON)/niq32.c

$(OBJ)/sim.obj: $(DRVCOMMON)/sim.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) -i$(IN1) $(DRVCOMMON)/sim.c

$(OBJ)/sim32.obj: $(DRVCOMMON)/sim32.c 
		cl470 $(COP32) $(CDEFS_DRV) $(INCDRV) -i$(IN1) $(DRVCOMMON)/sim32.c

$(OBJ)/timer.obj: $(DRVCOMMON)/timer.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) $(DRVCOMMON)/timer.c

$(OBJ)/armio.obj: $(DRVCOMMON)/armio.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) $(DRVCOMMON)/armio.c

$(OBJ)/init.obj: $(DRVCOMMON)/init.c 
		cl470 $(COPF) $(CDEFS_DRV) -D$(TIM_PROF) -i$(IPCM) -i$(IN1) \
		      $(INCDRV) $(HACK_INC) -i$(IL1) -i$(IL3) $(DRVCOMMON)/init.c

$(OBJ)/uart.obj: $(DRVCOMMON)/uart.c 
		cl470 $(COPF) $(CDEFS_DRV) -i$(IN1) $(INCDRV) \
		      $(DRVCOMMON)/uart.c

$(OBJ)/uartfax.obj: $(DRVCOMMON)/uartfax.c 
		cl470 $(COPF) $(CDEFS_DRV) -i$(IN1) $(INCDRV) \
		      $(DRVCOMMON)/uartfax.c

$(OBJ)/serialswitch.obj: $(DRVCOMMON)/serialswitch.c 
		cl470 $(COPF) $(CDEFS_DRV) -i$(IN1) -i$(IPCM) $(INCDRV) \
		      $(DRVCOMMON)/serialswitch.c

$(OBJ)/timer1.obj: $(DRVCOMMON)/timer1.c 
		cl470 $(COPF) $(CDEFS_DRV)  $(INCDRV) $(DRVCOMMON)/timer1.c

$(OBJ)/timer2.obj: $(DRVCOMMON)/timer2.c 
		cl470 $(COPF) $(CDEFS_DRV)  $(INCDRV) $(DRVCOMMON)/timer2.c

$(OBJ)/clkm.obj: $(DRVCOMMON)/clkm.c 
		cl470 $(COPF) $(CDEFS_DRV)  $(INCDRV) \
		      -i$(HINT) -i$(IN1) -i$(TPUSRC) $(DRVCOMMON)/clkm.c

$(OBJ)/inth.obj: $(DRVCOMMON)/inth.c 
		cl470 $(COPF) $(CDEFS_DRV)  $(INCDRV) \
		      -i$(HINT) -i$(IN1) -i$(TPUSRC) $(DRVCOMMON)/inth.c

$(OBJ)/flash_s.obj: $(DRVBOARD)/drvflash.s
	asm470 -me $(DRVBOARD)/drvflash.s $(OBJ)/flash_s.obj

$(OBJ)/pwr_cst.obj: $(DRVCOMMON)/pwr_cst.c 
		cl470 $(COPF) $(CDEFS_DRV) $(INCDRV) -i$(IN1) -i$(INCCONDAT) -i$(BT_GENERAL) -i$(BT_TRACE) $(DRVCOMMON)/pwr_cst.c
